/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.entity;

import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import nikita488.zycraft.init.ZYEntities;
import nikita488.zycraft.multiblock.IDynamicMultiBlock;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.MultiManager;

public class MultiEntity
extends Entity
implements IEntityAdditionalSpawnData {
    @Nullable
    private IDynamicMultiBlock parentMultiBlock;
    private int multiID = -1;

    public MultiEntity(EntityType<MultiEntity> type, World level) {
        super(type, level);
    }

    public MultiEntity(World level, IDynamicMultiBlock parentMultiBlock, int multiID) {
        super((EntityType)ZYEntities.MULTI_BLOCK.get(), level);
        this.parentMultiBlock = parentMultiBlock;
        this.multiID = multiID;
        this.field_70145_X = true;
        this.field_70156_m = true;
        BlockPos originPos = parentMultiBlock.origin();
        this.func_70107_b(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p());
        this.func_174826_a(parentMultiBlock.aabb());
    }

    private void computeClientMultiBlock() {
        if (!this.field_70170_p.func_201670_d() || this.multiID < 0) {
            return;
        }
        MultiBlock multiBlock = MultiManager.getInstance((IWorld)this.field_70170_p).getMultiBlock(this.multiID);
        if (multiBlock instanceof IDynamicMultiBlock) {
            this.parentMultiBlock = (IDynamicMultiBlock)((Object)multiBlock);
            this.func_174826_a(this.parentMultiBlock.aabb());
            this.multiID = -1;
        }
    }

    public void func_70071_h_() {
        this.computeClientMultiBlock();
        if (this.parentMultiBlock != null) {
            if (this.parentMultiBlock.isValid()) {
                this.parentMultiBlock.tick();
            } else {
                this.func_70106_y();
            }
        }
        this.field_70148_d = false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.multiID = buffer.func_150792_a();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.multiID);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT tag) {
    }

    protected void func_213281_b(CompoundNBT tag) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void func_174812_G() {
    }

    public void func_241841_a(ServerWorld level, LightningBoltEntity lightning) {
    }

    @Nullable
    public IDynamicMultiBlock parentMultiBlock() {
        return this.parentMultiBlock;
    }
}

