/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.compat.theoneprobe;

import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import nikita488.zycraft.ZYCraft;
import nikita488.zycraft.api.colorable.IColorable;
import nikita488.zycraft.api.fluid.IFluidSource;
import nikita488.zycraft.api.fluid.IFluidVoid;
import nikita488.zycraft.block.FabricatorBlock;
import nikita488.zycraft.block.state.properties.FabricatorMode;
import nikita488.zycraft.block.state.properties.ItemIOMode;
import nikita488.zycraft.block.state.properties.ValveIOMode;
import nikita488.zycraft.init.ZYBlocks;
import nikita488.zycraft.init.ZYLang;
import nikita488.zycraft.multiblock.child.block.ItemIOBlock;
import nikita488.zycraft.multiblock.child.block.ValveBlock;
import nikita488.zycraft.multiblock.child.tile.ValveTile;

public class ZYProbeInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public String getID() {
        return ZYCraft.string("default");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World level, BlockState state, IProbeHitData data) {
        BlockPos pos = data.getPos();
        Direction side = data.getSideHit();
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof IColorable) {
            this.addColorableProbeInfo(info, (IColorable)blockEntity, state, (IBlockDisplayReader)level, pos);
        } else if (ZYBlocks.FABRICATOR.has(state)) {
            this.addFabricatorProbeInfo(info, state);
        } else if (ZYBlocks.VALVE.has(state)) {
            this.addValveProbeInfo(info, level, state, pos);
        } else if (ZYBlocks.ITEM_IO.has(state)) {
            this.addItemIOProbeInfo(info, state);
        } else if (state.func_177230_c() instanceof IFluidSource) {
            this.addFluidSourceProbeInfo(info, (IFluidSource)state.func_177230_c(), level, state, pos, side);
        } else if (state.func_177230_c() instanceof IFluidVoid) {
            this.addFluidVoidProbeInfo(info, (IFluidVoid)state.func_177230_c(), level, state, pos, side);
        }
    }

    private void addColorableProbeInfo(IProbeInfo info, IColorable colorable, BlockState state, IBlockDisplayReader getter, BlockPos pos) {
        int color = colorable.getColor(state, getter, pos);
        info.mcText((ITextComponent)ZYLang.CURRENT_COLOR_LABEL);
        info.mcText((ITextComponent)ZYLang.copy(ZYLang.RED_INFO, color >> 16 & 0xFF));
        info.mcText((ITextComponent)ZYLang.copy(ZYLang.GREEN_INFO, color >> 8 & 0xFF));
        info.mcText((ITextComponent)ZYLang.copy(ZYLang.BLUE_INFO, color & 0xFF));
    }

    private void addFabricatorProbeInfo(IProbeInfo info, BlockState state) {
        info.text(CompoundText.create().label((ITextComponent)ZYLang.MODE_LABEL).info((ITextComponent)((FabricatorMode)((Object)state.func_177229_b(FabricatorBlock.MODE))).displayName()));
    }

    private void addValveProbeInfo(IProbeInfo info, World level, BlockState state, BlockPos pos) {
        info.mcText((ITextComponent)ZYLang.MODE_LABEL.func_230531_f_().func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)((ValveIOMode)((Object)state.func_177229_b(ValveBlock.IO_MODE))).displayName()));
        TileEntity blockEntity = level.func_175625_s(pos);
        if (!(blockEntity instanceof ValveTile)) {
            return;
        }
        FluidStack storedFluid = ((ValveTile)blockEntity).getStoredFluid();
        if (!storedFluid.isEmpty()) {
            info.horizontal().text(CompoundText.create().label((ITextComponent)ZYLang.STORED_FLUID_LABEL)).tankSimple(storedFluid.getAmount(), storedFluid, info.defaultProgressStyle().prefix((ITextComponent)storedFluid.getDisplayName().func_230532_e_().func_240702_b_(" ")).suffix((ITextComponent)new StringTextComponent(" mB")));
        }
    }

    private void addItemIOProbeInfo(IProbeInfo info, BlockState state) {
        info.mcText((ITextComponent)ZYLang.MODE_LABEL.func_230531_f_().func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)((ItemIOMode)((Object)state.func_177229_b(ItemIOBlock.IO_MODE))).displayName()));
    }

    private void addFluidSourceProbeInfo(IProbeInfo info, IFluidSource source, World level, BlockState state, BlockPos pos, Direction side) {
        FluidStack fluid = source.getFluid(state, level, pos, side);
        if (!fluid.isEmpty()) {
            info.horizontal().text(CompoundText.create().label((ITextComponent)ZYLang.SOURCE_FLUID_LABEL)).tankSimple(fluid.getAmount(), fluid, info.defaultProgressStyle().prefix((ITextComponent)fluid.getDisplayName().func_230532_e_().func_240702_b_(" ")).suffix((ITextComponent)new StringTextComponent(" mB")));
        }
    }

    private void addFluidVoidProbeInfo(IProbeInfo info, IFluidVoid fluidVoid, World level, BlockState state, BlockPos pos, Direction side) {
        int drainAmount;
        FluidStack fluidToDrain = fluidVoid.getFluidToDrain(state, level, pos, side);
        int n = drainAmount = fluidToDrain.isEmpty() ? fluidVoid.getDrainAmount(state, level, pos, side) : 0;
        if (!fluidToDrain.isEmpty()) {
            info.horizontal().text(CompoundText.create().label((ITextComponent)ZYLang.VOID_FLUID_LABEL)).tankSimple(fluidToDrain.getAmount(), fluidToDrain, info.defaultProgressStyle().prefix((ITextComponent)fluidToDrain.getDisplayName().func_230532_e_().func_240702_b_(" ")).suffix((ITextComponent)new StringTextComponent(" mB")));
        } else if (drainAmount > 0) {
            info.horizontal().text(CompoundText.create().label((ITextComponent)ZYLang.VOID_FLUID_LABEL).info((ITextComponent)ZYLang.copy(ZYLang.FLUID_INFO, "Any", drainAmount)));
        }
    }
}

