/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.renderer.multiblock;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import nikita488.zycraft.client.ZYRenderTypes;
import nikita488.zycraft.multiblock.MultiBlock;
import nikita488.zycraft.multiblock.child.IMultiChild;
import nikita488.zycraft.util.ZYConstants;

public class MultiHighlightRenderer {
    private static final float MIN = -0.009f;
    private static final float MAX = 1.009f;
    private static final BlockPos.Mutable LAST_POS = new BlockPos.Mutable();
    private static final BlockPos.Mutable RELATIVE_POS = new BlockPos.Mutable();
    private static long startTime;
    private static long lastTime;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(MultiHighlightRenderer::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(MultiHighlightRenderer::onWorldUnload);
        MinecraftForge.EVENT_BUS.addListener(MultiHighlightRenderer::onDrawBlockHighlight);
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult hitResult = mc.field_71476_x;
        if (hitResult != null && hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return;
        }
        ClientWorld level = mc.field_71441_e;
        if (level != null && level.func_82737_E() - lastTime > 10L) {
            LAST_POS.func_189533_g((Vector3i)BlockPos.field_177992_a);
        }
    }

    private static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            LAST_POS.func_189533_g((Vector3i)BlockPos.field_177992_a);
        }
    }

    private static void onDrawBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        World level = event.getInfo().func_216773_g().func_130014_f_();
        BlockPos highlightPos = event.getTarget().func_216350_a();
        TileEntity blockEntity = level.func_175625_s(highlightPos);
        long time = level.func_82737_E();
        if (!LAST_POS.equals((Object)highlightPos)) {
            LAST_POS.func_189533_g((Vector3i)highlightPos);
            startTime = time;
        }
        lastTime = time;
        if (blockEntity instanceof IMultiChild) {
            IMultiChild child = (IMultiChild)blockEntity;
            if (!child.hasParents()) {
                return;
            }
            float ticksElapsed = (float)(time - startTime) + event.getPartialTicks();
            float strength = Math.max(0.0f, 1.0f - ticksElapsed / 100.0f);
            if (strength <= 0.0f) {
                return;
            }
            ObjectOpenHashSet highlightBlocks = new ObjectOpenHashSet();
            for (MultiBlock multiBlock : child.parentMultiBlocks()) {
                highlightBlocks.addAll(multiBlock.childBlocks());
            }
            MatrixStack stack = event.getMatrix();
            Vector3d cameraPos = event.getInfo().func_216785_c();
            stack.func_227860_a_();
            stack.func_227861_a_(-cameraPos.func_82615_a(), -cameraPos.func_82617_b(), -cameraPos.func_82616_c());
            IVertexBuilder buffer = event.getBuffers().getBuffer(ZYRenderTypes.MULTI_HIGHLIGHT);
            for (BlockPos pos : highlightBlocks) {
                for (Direction side : ZYConstants.DIRECTIONS) {
                    if (highlightBlocks.contains((Object)RELATIVE_POS.func_239622_a_((Vector3i)pos, side))) continue;
                    MultiHighlightRenderer.renderHighlightQuad(stack, buffer, pos, side, 0.3f * strength);
                }
            }
            stack.func_227865_b_();
        }
    }

    private static void renderHighlightQuad(MatrixStack stack, IVertexBuilder buffer, BlockPos pos, Direction side, float alpha) {
        stack.func_227860_a_();
        stack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        switch (side) {
            case DOWN: {
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                break;
            }
            case UP: {
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
                break;
            }
            case NORTH: {
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
                break;
            }
            case SOUTH: {
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
                break;
            }
            case WEST: {
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, -0.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
                break;
            }
            case EAST: {
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, 1.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, 1.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, 1.009f, -0.009f, -0.009f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            }
        }
        stack.func_227865_b_();
    }
}

