/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.renderer.multiblock;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import nikita488.zycraft.util.Color;
import nikita488.zycraft.util.Cuboid6i;

public class MultiFluidRenderer {
    private static final Vector3f ORIGIN = new Vector3f();

    public static void render(MatrixStack pose, IRenderTypeBuffer source, FluidStack stack, Cuboid6i bounds, float resolution, float density, IBlockDisplayReader getter, BlockPos lightPos) {
        MultiFluidRenderer.render(pose, source, stack, bounds, resolution, density, WorldRenderer.func_228421_a_((IBlockDisplayReader)getter, (BlockPos)lightPos));
    }

    public static void render(MatrixStack pose, IRenderTypeBuffer source, FluidStack stack, Cuboid6i bounds, float resolution, float density, int lightMap) {
        if (stack.isEmpty()) {
            return;
        }
        Fluid fluid = stack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        int color = attributes.getColor(stack);
        TextureAtlasSprite sprite = ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getStillTexture(stack)).func_229314_c_();
        float fluidHeight = bounds.height();
        if (attributes.isGaseous(stack)) {
            color = Color.argb(color, (int)(Math.pow(density, 0.4f) * 255.0));
        } else {
            fluidHeight *= density;
        }
        lightMap = LightTexture.func_228451_a_((int)Math.max(LightTexture.func_228450_a_((int)lightMap), attributes.getLuminosity(stack)), (int)LightTexture.func_228454_b_((int)lightMap));
        for (RenderType type : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((FluidState)fluid.func_207188_f(), (RenderType)type)) continue;
            IVertexBuilder builder = source.getBuffer(type);
            ORIGIN.func_195905_a((float)bounds.minX(), (float)bounds.minY(), (float)bounds.minZ());
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.DOWN, resolution, bounds.width(), bounds.depth(), color, sprite, lightMap);
            ORIGIN.func_195905_a((float)bounds.minX(), (float)bounds.minY() + fluidHeight, (float)(bounds.maxZ() + 1));
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.UP, resolution, bounds.width(), bounds.depth(), color, sprite, lightMap);
            ORIGIN.func_195905_a((float)bounds.minX(), (float)bounds.minY(), (float)(bounds.maxZ() + 1));
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.NORTH, resolution, bounds.width(), fluidHeight, color, sprite, lightMap);
            ORIGIN.func_195905_a((float)(bounds.maxX() + 1), (float)bounds.minY(), (float)bounds.minZ());
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.SOUTH, resolution, bounds.width(), fluidHeight, color, sprite, lightMap);
            ORIGIN.func_195905_a((float)(bounds.maxX() + 1), (float)bounds.minY(), (float)(bounds.maxZ() + 1));
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.WEST, resolution, bounds.depth(), fluidHeight, color, sprite, lightMap);
            ORIGIN.func_195905_a((float)bounds.minX(), (float)bounds.minY(), (float)bounds.minZ());
            MultiFluidRenderer.fillFluidQuads(pose, builder, Direction.EAST, resolution, bounds.depth(), fluidHeight, color, sprite, lightMap);
        }
    }

    private static Vector3f cross(Vector3f vec1, Vector3f vec2) {
        vec1.func_195896_c(vec2);
        return vec1;
    }

    private static Vector3f scale(Vector3f vec, float amount) {
        vec = vec.func_229195_e_();
        vec.func_195898_a(amount);
        return vec;
    }

    private static void fillFluidQuads(MatrixStack pose, IVertexBuilder consumer, Direction side, float resolution, float width, float height, int color, TextureAtlasSprite sprite, int lightMap) {
        pose.func_227860_a_();
        pose.func_227861_a_((double)ORIGIN.func_195899_a(), (double)ORIGIN.func_195900_b(), (double)ORIGIN.func_195902_c());
        Matrix4f matrix = pose.func_227866_c_().func_227870_a_();
        Vector3f widthAxis = side.func_176740_k().func_176722_c() ? MultiFluidRenderer.cross(side.func_229386_k_(), Vector3f.field_229181_d_) : Vector3f.field_229179_b_;
        Vector3f heightAxis = side.func_176740_k().func_200128_b() ? MultiFluidRenderer.cross(side.func_229386_k_(), Vector3f.field_229179_b_) : Vector3f.field_229181_d_;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        float u1 = sprite.func_94209_e();
        float v2 = sprite.func_94210_h();
        float sideX = side.func_82601_c();
        float sideY = side.func_96559_d();
        float sideZ = side.func_82599_e();
        for (float quadX = 0.0f; quadX < width; quadX += resolution) {
            for (float quadY = 0.0f; quadY < height; quadY += resolution) {
                float quadWidth = Math.min(width - quadX, resolution);
                float quadHeight = Math.min(height - quadY, resolution);
                float u2 = u1 + (sprite.func_94212_f() - u1) * quadWidth / resolution;
                float v1 = v2 - (v2 - sprite.func_94206_g()) * quadHeight / resolution;
                Vector3f x1 = MultiFluidRenderer.scale(widthAxis, quadX);
                Vector3f x2 = MultiFluidRenderer.scale(widthAxis, quadX + quadWidth);
                Vector3f y1 = MultiFluidRenderer.scale(heightAxis, quadY);
                Vector3f y2 = MultiFluidRenderer.scale(heightAxis, quadY + quadHeight);
                consumer.func_227888_a_(matrix, x1.func_195899_a() + y2.func_195899_a(), x1.func_195900_b() + y2.func_195900_b(), x1.func_195902_c() + y2.func_195902_c()).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(lightMap).func_225584_a_(sideX, sideY, sideZ).func_181675_d();
                consumer.func_227888_a_(matrix, x1.func_195899_a() + y1.func_195899_a(), x1.func_195900_b() + y1.func_195900_b(), x1.func_195902_c() + y1.func_195902_c()).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(lightMap).func_225584_a_(sideX, sideY, sideZ).func_181675_d();
                consumer.func_227888_a_(matrix, x2.func_195899_a() + y1.func_195899_a(), x2.func_195900_b() + y1.func_195900_b(), x2.func_195902_c() + y1.func_195902_c()).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(lightMap).func_225584_a_(sideX, sideY, sideZ).func_181675_d();
                consumer.func_227888_a_(matrix, x2.func_195899_a() + y2.func_195899_a(), x2.func_195900_b() + y2.func_195900_b(), x2.func_195902_c() + y2.func_195902_c()).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(lightMap).func_225584_a_(sideX, sideY, sideZ).func_181675_d();
            }
        }
        pose.func_227865_b_();
    }
}

