/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.pigment;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.pigment.PigmentChannelModule;
import terrails.xnetgases.module.pigment.PigmentUtils;

public class PigmentConnectorSettings
extends AbstractConnectorSettings {
    private PigmentMode pigmentMode = PigmentMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private int speed = 2;
    private ItemStack filter = ItemStack.field_190927_a;
    private final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "filter"});
    private final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "filter", "speed"});

    public PigmentConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public PigmentMode getPigmentMode() {
        return this.pigmentMode;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nonnull
    public Integer getRate() {
        return this.rate == null ? (Integer)PigmentChannelModule.maxPigmentRateNormal.get() : this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.pigmentMode) {
            case INS: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        int maxRate;
        String[] speeds;
        this.advanced = gui.isAdvanced();
        if (this.advanced) {
            speeds = new String[]{"10", "20", "60", "100", "200"};
            maxRate = (Integer)PigmentChannelModule.maxPigmentRateAdvanced.get();
        } else {
            speeds = new String[]{"20", "60", "100", "200"};
            maxRate = (Integer)PigmentChannelModule.maxPigmentRateNormal.get();
        }
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices("mode", "Insert or extract mode", (Enum)this.pigmentMode, (Enum[])PigmentMode.values()).choices("speed", "Number of ticks for each operation", Integer.toString(this.speed * 10), speeds).nl().label("Pri").integer("priority", "Insertion priority", this.priority, 36).nl().label("Rate").integer("rate", this.pigmentMode == PigmentMode.EXT ? "Pigment extraction rate|(max " + maxRate + "mb)" : "Pigment insertion rate|(max " + maxRate + "mb)", this.rate, 36, Integer.valueOf(maxRate)).shift(10).label(this.pigmentMode == PigmentMode.EXT ? "Min" : "Max").integer("minmax", this.pigmentMode == PigmentMode.EXT ? "Keep this amount of|pigment in tank" : "Disable insertion if|pigment level is too high", this.minmax, 36).nl().label("Filter").ghostSlot("filter", this.filter);
    }

    public boolean isEnabled(String tag) {
        if (this.pigmentMode == PigmentMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return this.INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return this.EXTRACT_TAGS.contains(tag);
    }

    @Nullable
    public PigmentStack getMatcher() {
        IPigmentHandler handler;
        if (!this.filter.func_190926_b() && Capabilities.PIGMENT_HANDLER_CAPABILITY != null && this.filter.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() && (handler = (IPigmentHandler)this.filter.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IPigmentHandler Capability doesn't exist!"))).getTanks() > 0) {
            return (PigmentStack)handler.getChemicalInTank(0);
        }
        return null;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.pigmentMode = PigmentMode.valueOf(((String)data.get("mode")).toUpperCase());
        this.rate = (Integer)data.get("rate");
        this.minmax = (Integer)data.get("minmax");
        this.priority = (Integer)data.get("priority");
        this.speed = Integer.parseInt((String)data.get("speed")) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.filter = (ItemStack)data.get("filter");
        if (this.filter == null) {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        PigmentConnectorSettings.setEnumSafe((JsonObject)object, (String)"mode", (Enum)this.pigmentMode);
        PigmentConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        PigmentConnectorSettings.setIntegerSafe((JsonObject)object, (String)"rate", (Integer)this.rate);
        PigmentConnectorSettings.setIntegerSafe((JsonObject)object, (String)"minmax", (Integer)this.minmax);
        PigmentConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        if (!this.filter.func_190926_b()) {
            object.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.rate != null && this.rate > (Integer)PigmentChannelModule.maxPigmentRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.pigmentMode = (PigmentMode)PigmentConnectorSettings.getEnumSafe((JsonObject)object, (String)"mode", PigmentUtils::getConnectorModeFrom);
        this.priority = PigmentConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.rate = PigmentConnectorSettings.getIntegerSafe((JsonObject)object, (String)"rate");
        this.minmax = PigmentConnectorSettings.getIntegerSafe((JsonObject)object, (String)"minmax");
        this.speed = PigmentConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        this.filter = object.has("filter") ? JSonTools.jsonToItemStack((JsonObject)object.get("filter").getAsJsonObject()) : ItemStack.field_190927_a;
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.pigmentMode = PigmentMode.values()[tag.func_74771_c("mode")];
        this.priority = tag.func_74764_b("priority") ? Integer.valueOf(tag.func_74762_e("priority")) : null;
        this.rate = tag.func_74764_b("rate") ? Integer.valueOf(tag.func_74762_e("rate")) : null;
        this.minmax = tag.func_74764_b("minmax") ? Integer.valueOf(tag.func_74762_e("minmax")) : null;
        this.speed = tag.func_74762_e("speed");
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (tag.func_74764_b("filter")) {
            CompoundNBT itemTag = tag.func_74775_l("filter");
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("mode", (byte)this.pigmentMode.ordinal());
        if (this.priority != null) {
            tag.func_74768_a("priority", this.priority.intValue());
        }
        if (this.rate != null) {
            tag.func_74768_a("rate", this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.func_74768_a("minmax", this.minmax.intValue());
        }
        tag.func_74768_a("speed", this.speed);
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a("filter", (INBT)itemTag);
        }
    }

    public static enum PigmentMode {
        INS,
        EXT;

    }
}

