/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.LogicUtils;
import terrails.xnetgases.module.logic.XGSensor;

public class XGLogicConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_REDSTONE_OUT = "rsout";
    public static final String TAG_SENSORS = "sensors";
    public static final String TAG_COLORS = "colors";
    private static final Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});
    public static final int SENSORS = 4;
    private LogicMode logicMode = LogicMode.SENSOR;
    private final List<XGSensor> sensors = new ArrayList<XGSensor>(4);
    private int colors;
    private int speed = 2;
    private Integer redstoneOut;

    public XGLogicConnectorSettings(@Nonnull Direction side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new XGSensor(i));
        }
    }

    public List<XGSensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    public Integer getRedstoneOut() {
        return this.redstoneOut;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.logicMode) {
            case SENSOR: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 26, 70, 13, 10);
            }
            case OUTPUT: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 39, 70, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.logicMode != LogicMode.OUTPUT;
        }
        if (tag.equals("speed")) {
            return true;
        }
        for (XGSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public int getSpeed() {
        return this.speed;
    }

    public LogicMode getLogicMode() {
        return this.logicMode;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices("mode", "Sensor or Output mode", (Enum)this.logicMode, (Enum[])LogicMode.values()).choices("speed", this.logicMode == LogicMode.SENSOR ? "Number of ticks for each check" : "Number of ticks for each operation", Integer.toString(this.speed * 5), speeds).nl();
        switch (this.logicMode) {
            case SENSOR: {
                for (XGSensor sensor : this.sensors) {
                    sensor.createGui(gui);
                }
                break;
            }
            case OUTPUT: {
                gui.label("Redstone:").integer(TAG_REDSTONE_OUT, "Redstone output value", this.redstoneOut, 40, Integer.valueOf(16)).nl();
            }
        }
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.logicMode = LogicMode.valueOf(((String)data.get("mode")).toUpperCase());
        this.speed = Integer.parseInt((String)data.get("speed")) / 5;
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (this.logicMode == LogicMode.SENSOR) {
            for (XGSensor sensor : this.sensors) {
                sensor.update(data);
            }
        } else {
            this.redstoneOut = (Integer)data.get(TAG_REDSTONE_OUT);
        }
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        XGLogicConnectorSettings.setEnumSafe((JsonObject)object, (String)"mode", (Enum)this.logicMode);
        XGLogicConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        JsonArray sensorArray = new JsonArray();
        for (XGSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            sensor.writeToJson(o);
            sensorArray.add((JsonElement)o);
        }
        object.add(TAG_SENSORS, (JsonElement)sensorArray);
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.logicMode = (LogicMode)XGLogicConnectorSettings.getEnumSafe((JsonObject)object, (String)"mode", LogicUtils::getLogicModeFrom);
        this.speed = XGLogicConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        JsonArray sensorArray = object.get(TAG_SENSORS).getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            XGSensor sensor = new XGSensor(this.sensors.size());
            sensor.readFromJson(o);
            this.sensors.add(sensor);
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("mode", (byte)this.logicMode.ordinal());
        tag.func_74768_a("speed", this.speed);
        tag.func_74768_a(TAG_COLORS, this.colors);
        for (XGSensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
        if (this.redstoneOut != null) {
            tag.func_74768_a(TAG_REDSTONE_OUT, this.redstoneOut.intValue());
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.logicMode = LogicMode.values()[tag.func_74771_c("mode")];
        this.speed = tag.func_74762_e("speed");
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.colors = tag.func_74762_e(TAG_COLORS);
        for (XGSensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
        this.redstoneOut = tag.func_74762_e(TAG_REDSTONE_OUT);
    }

    public static enum LogicMode {
        SENSOR,
        OUTPUT;

    }
}

