/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.infuse;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.ChemicalConnectorSettings;
import terrails.xnetgases.module.infuse.InfuseChannelModule;
import terrails.xnetgases.module.infuse.InfuseUtils;

public class InfuseConnectorSettings
extends ChemicalConnectorSettings<InfusionStack> {
    private InfuseMode infuseMode = InfuseMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private int speed = 2;
    private ItemStack filter = ItemStack.field_190927_a;
    private final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "filter"});
    private final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "filter", "speed"});

    public InfuseConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public InfuseMode getInfuseMode() {
        return this.infuseMode;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nonnull
    public Integer getRate() {
        return this.rate == null ? (Integer)InfuseChannelModule.maxInfuseRateNormal.get() : this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.infuseMode) {
            case INS: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        int maxRate;
        String[] speeds;
        this.advanced = gui.isAdvanced();
        if (this.advanced) {
            speeds = new String[]{"10", "20", "60", "100", "200"};
            maxRate = (Integer)InfuseChannelModule.maxInfuseRateAdvanced.get();
        } else {
            speeds = new String[]{"20", "60", "100", "200"};
            maxRate = (Integer)InfuseChannelModule.maxInfuseRateNormal.get();
        }
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices("mode", "Insert or extract mode", (Enum)this.infuseMode, (Enum[])InfuseMode.values()).choices("speed", "Number of ticks for each operation", Integer.toString(this.speed * 10), speeds).nl().label("Pri").integer("priority", "Insertion priority", this.priority, 36).nl().label("Rate").integer("rate", this.infuseMode == InfuseMode.EXT ? "Infuse extraction rate|(max " + maxRate + "mb)" : "Infuse insertion rate|(max " + maxRate + "mb)", this.rate, 36, Integer.valueOf(maxRate)).shift(10).label(this.infuseMode == InfuseMode.EXT ? "Min" : "Max").integer("minmax", this.infuseMode == InfuseMode.EXT ? "Keep this amount of|infuse in tank" : "Disable insertion if|infuse level is too high", this.minmax, 36).nl().label("Filter").ghostSlot("filter", this.filter);
    }

    @Override
    public boolean isEnabled(String tag) {
        if (this.infuseMode == InfuseMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return this.INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return this.EXTRACT_TAGS.contains(tag);
    }

    @Override
    @Nullable
    public InfusionStack getMatcher() {
        IInfusionHandler handler;
        if (!this.filter.func_190926_b() && Capabilities.INFUSION_HANDLER_CAPABILITY != null && this.filter.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() && (handler = (IInfusionHandler)this.filter.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IInfusionHandler Capability doesn't exist!"))).getTanks() > 0) {
            return (InfusionStack)handler.getChemicalInTank(0);
        }
        return null;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.infuseMode = InfuseMode.valueOf(((String)data.get("mode")).toUpperCase());
        this.rate = (Integer)data.get("rate");
        this.minmax = (Integer)data.get("minmax");
        this.priority = (Integer)data.get("priority");
        this.speed = Integer.parseInt((String)data.get("speed")) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.filter = (ItemStack)data.get("filter");
        if (this.filter == null) {
            this.filter = ItemStack.field_190927_a;
        }
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        InfuseConnectorSettings.setEnumSafe((JsonObject)object, (String)"mode", (Enum)this.infuseMode);
        InfuseConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        InfuseConnectorSettings.setIntegerSafe((JsonObject)object, (String)"rate", (Integer)this.rate);
        InfuseConnectorSettings.setIntegerSafe((JsonObject)object, (String)"minmax", (Integer)this.minmax);
        InfuseConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        if (!this.filter.func_190926_b()) {
            object.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.rate != null && this.rate > (Integer)InfuseChannelModule.maxInfuseRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.infuseMode = (InfuseMode)InfuseConnectorSettings.getEnumSafe((JsonObject)object, (String)"mode", InfuseUtils::getConnectorModeFrom);
        this.priority = InfuseConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.rate = InfuseConnectorSettings.getIntegerSafe((JsonObject)object, (String)"rate");
        this.minmax = InfuseConnectorSettings.getIntegerSafe((JsonObject)object, (String)"minmax");
        this.speed = InfuseConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        this.filter = object.has("filter") ? JSonTools.jsonToItemStack((JsonObject)object.get("filter").getAsJsonObject()) : ItemStack.field_190927_a;
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.infuseMode = InfuseMode.values()[tag.func_74771_c("mode")];
        this.priority = tag.func_74764_b("priority") ? Integer.valueOf(tag.func_74762_e("priority")) : null;
        this.rate = tag.func_74764_b("rate") ? Integer.valueOf(tag.func_74762_e("rate")) : null;
        this.minmax = tag.func_74764_b("minmax") ? Integer.valueOf(tag.func_74762_e("minmax")) : null;
        this.speed = tag.func_74762_e("speed");
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (tag.func_74764_b("filter")) {
            CompoundNBT itemTag = tag.func_74775_l("filter");
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("mode", (byte)this.infuseMode.ordinal());
        if (this.priority != null) {
            tag.func_74768_a("priority", this.priority.intValue());
        }
        if (this.rate != null) {
            tag.func_74768_a("rate", this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.func_74768_a("minmax", this.minmax.intValue());
        }
        tag.func_74768_a("speed", this.speed);
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a("filter", (INBT)itemTag);
        }
    }

    public static enum InfuseMode {
        INS,
        EXT;

    }
}

