/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.gas;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.helper.ChannelModule;
import terrails.xnetgases.module.gas.GasChannelSettings;
import terrails.xnetgases.module.gas.GasConnectorSettings;
import terrails.xnetgases.module.gas.GasUtils;

public class GasChannelModule
extends ChannelModule {
    public static ForgeConfigSpec.IntValue maxGasRateNormal;
    public static ForgeConfigSpec.IntValue maxGasRateAdvanced;

    public String getID() {
        return "mekanism.gas";
    }

    public String getName() {
        return "Mekanism Gas";
    }

    public boolean supportsBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return GasUtils.getGasHandlerFor((ICapabilityProvider)world.func_175625_s(pos), direction).isPresent();
    }

    @Nonnull
    public IConnectorSettings createConnector(@Nonnull Direction direction) {
        return new GasConnectorSettings(direction);
    }

    @Nonnull
    public IChannelSettings createChannel() {
        return new GasChannelSettings();
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        maxGasRateNormal = builder.comment("Maximum gas per operation that a normal connector can input or output").defineInRange("maxGasRateNormal", 1000, 1, 1000000000);
        maxGasRateAdvanced = builder.comment("Maximum gas per operation that an advanced connector can input or output").defineInRange("maxGasRateAdvanced", 5000, 1, 1000000000);
    }
}

