/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.oss;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import ipsis.woot.util.oss.WootFakePlayer;
import java.util.Map;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="woot", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WootFakePlayerFactory {
    private static Map<GameProfile, WootFakePlayer> fakePlayers = Maps.newHashMap();

    public static WootFakePlayer get(ServerWorld world, GameProfile username) {
        if (!fakePlayers.containsKey(username)) {
            WootFakePlayer fakePlayer = new WootFakePlayer(world, username);
            fakePlayers.put(username, fakePlayer);
        }
        return fakePlayers.get(username);
    }

    public static void unloadWorld(ServerWorld world) {
        fakePlayers.entrySet().removeIf(entry -> ((WootFakePlayer)((Object)((Object)entry.getValue()))).field_70170_p == world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            WootFakePlayerFactory.unloadWorld((ServerWorld)event.getWorld());
        }
    }
}

