/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.Woot;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidStackHelper {
    public static FluidStack parse(@Nonnull JsonObject jsonObject) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid");
        }
        return new FluidStack(fluid, JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"amount", (int)1000));
    }

    public static JsonObject create(@Nonnull FluidStack fluidStack) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", fluidStack.getFluid().getFluid().getRegistryName().toString());
        jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
        return jsonObject;
    }

    public static FluidStack reduceByPercentage(FluidStack fluidStack, double p) {
        p = MathHelper.func_151237_a((double)p, (double)0.0, (double)100.0);
        Woot.setup.getLogger().debug("reduceByPercentage: {} @ {}%%", (Object)fluidStack.getAmount(), (Object)p);
        if (p == 0.0 || fluidStack.isEmpty()) {
            return fluidStack;
        }
        if (p == 100.0) {
            return FluidStack.EMPTY;
        }
        int reduction = (int)((double)((float)fluidStack.getAmount() / 100.0f) * p);
        int left = fluidStack.getAmount() - reduction;
        fluidStack.setAmount(left);
        return fluidStack;
    }
}

