/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator;

import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.simulator.MobSimulatorConfiguration;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.library.LootLibrary;
import ipsis.woot.simulator.tartarus.Cell;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobSimulator {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Random RANDOM = new Random();
    private static final int NUM_SIMULATION_CELLS = 128;
    private static final BlockPos ORIGIN_POS = new BlockPos(0, 0, 0);
    private static MobSimulator INSTANCE = new MobSimulator();
    private LootLibrary library;
    private Cell[] cells;
    private List<FakeMobKey> waitingForCell = new ArrayList<FakeMobKey>();
    private int currTicks = 0;

    public static MobSimulator getInstance() {
        return INSTANCE;
    }

    public MobSimulator() {
        this.library = new LootLibrary();
        this.cells = new Cell[128];
        BlockPos[] offsets = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(0, 0, 9), new BlockPos(9, 0, 9), new BlockPos(9, 0, 9)};
        for (int floor = 0; floor < 32; ++floor) {
            for (int cell = 0; cell < 4; ++cell) {
                int flootCell = floor * 4;
                this.cells[flootCell + cell] = new Cell(new BlockPos(ORIGIN_POS.func_177958_n() + offsets[cell].func_177958_n(), flootCell * 16 + offsets[cell].func_177956_o(), ORIGIN_POS.func_177952_p() + offsets[cell].func_177952_p()));
            }
        }
    }

    private boolean isLearningComplete(@Nonnull FakeMobKey fakeMobKey) {
        return this.library.getSimulatedKills(fakeMobKey) >= (Integer)MobSimulatorConfiguration.SIMULATION_MOB_COUNT.get();
    }

    @Nonnull
    public List<SimulatedMobDropSummary> getDropSummary(@Nonnull FakeMob fakeMob) {
        return this.library.getDropSummary(fakeMob);
    }

    @Nonnull
    public List<ItemStack> getRolledDrops(@Nonnull FakeMobKey fakeMobKey) {
        return this.library.getRolledDrops(fakeMobKey);
    }

    @Nonnull
    public Set<FakeMob> getKnownMobs() {
        return this.library.getKnownMobs();
    }

    @Nonnull
    public List<FakeMobKey> getSimulations() {
        ArrayList<FakeMobKey> mobs = new ArrayList<FakeMobKey>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (!this.cells[i].isOccupied()) continue;
            mobs.add(this.cells[i].getOccupant());
        }
        return mobs;
    }

    @Nonnull
    public List<FakeMobKey> getWaiting() {
        ArrayList<FakeMobKey> mobs = new ArrayList<FakeMobKey>();
        this.waitingForCell.forEach(m -> mobs.add(new FakeMobKey(m.getMob(), m.getLooting())));
        return mobs;
    }

    public JsonObject toJson() {
        return this.library.toJson();
    }

    public void fromJson(JsonObject jsonObject) {
        this.library.fromJson(jsonObject);
    }

    public boolean learn(@Nonnull FakeMob fakeMob) {
        if (!fakeMob.isValid()) {
            return false;
        }
        if (!FakeMob.isInEntityList(fakeMob)) {
            return false;
        }
        if (this.library.getKnownMobs().contains(fakeMob)) {
            Woot.setup.getLogger().debug("learn {} already known", (Object)fakeMob);
            return false;
        }
        if (!PolicyRegistry.get().canSimulate(fakeMob.getResourceLocation())) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            FakeMobKey fakeMobKey = new FakeMobKey(fakeMob, i);
            if (this.isLearningComplete(fakeMobKey)) continue;
            this.waitingForCell.add(fakeMobKey);
        }
        return true;
    }

    public void flush(@Nonnull FakeMob fakeMob) {
        if (fakeMob.isValid()) {
            this.library.flush(fakeMob);
        }
    }

    public void learnSimulatedDrops(@Nonnull FakeMobKey fakeMobKey, @Nonnull List<ItemStack> drops) {
        this.library.learnSimulatedDrops(fakeMobKey, drops);
    }

    public void learnCustomDrop(@Nonnull FakeMobKey fakeMobKey, @Nonnull ItemStack drop, float dropChance, HashMap<Integer, Integer> stackSizes) {
        this.library.learnCustomDrop(fakeMobKey, drop, dropChance, stackSizes);
    }

    public boolean isEqualForLearning(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    public void tick(World world) {
        if (world == null) {
            return;
        }
        this.currTicks = MathHelper.func_76125_a((int)(this.currTicks + 1), (int)0, (int)Integer.MAX_VALUE);
        if (this.currTicks < (Integer)MobSimulatorConfiguration.SIMULATION_TICKS_PER_SIM_TICK.get()) {
            return;
        }
        int cellsProcessed = 0;
        for (int i = 0; i < this.cells.length && cellsProcessed <= (Integer)MobSimulatorConfiguration.SIMULATION_CELLS_PER_SIM_TICK.get(); ++i) {
            Cell cell = this.cells[i];
            if (!cell.isOccupied()) continue;
            this.library.learnSimulatedDropsSilent(cell.getOccupant(), cell.sweep(world));
            if (this.isLearningComplete(cell.getOccupant())) {
                cell.free();
            } else {
                cell.run(world);
            }
            cell.clean(world);
            ++cellsProcessed;
        }
        if (!this.waitingForCell.isEmpty()) {
            Iterator<FakeMobKey> iterator = this.waitingForCell.iterator();
            block1: while (iterator.hasNext()) {
                FakeMobKey fakeMobKey = iterator.next();
                for (Cell cell : this.cells) {
                    if (cell.isOccupied()) continue;
                    Woot.setup.getLogger().debug("Allocated {} to cell {}", (Object)fakeMobKey, (Object)cell);
                    cell.setMob(fakeMobKey);
                    cell.run(world);
                    iterator.remove();
                    continue block1;
                }
            }
        }
    }
}

