/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.EnchantSqueezerContainer;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootEnergyStorage;
import ipsis.woot.util.WootFluidTank;
import ipsis.woot.util.WootMachineTileEntity;
import ipsis.woot.util.helper.EnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantSqueezerTileEntity
extends WootMachineTileEntity
implements WootDebug,
INamedContainerProvider {
    public final IItemHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EnchantSqueezerTileEntity.this.onContentsChanged(slot);
            EnchantSqueezerTileEntity.this.func_70296_d();
        }

        public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
            return EnchantmentHelper.isEnchanted(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private LazyOptional<WootFluidTank> outputTank = LazyOptional.of(this::createTank);
    private LazyOptional<WootEnergyStorage> energyStorage = LazyOptional.of(this::createEnergy);
    public static int INPUT_SLOT = 0;
    private final LazyOptional<IItemHandler> inventoryGetter = LazyOptional.of(() -> this.inventory);

    public EnchantSqueezerTileEntity() {
        super((TileEntityType)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK_TILE.get());
    }

    public void onLoad() {
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, WootMachineTileEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.outputTank.map(WootFluidTank::isEmpty).orElse(true).booleanValue()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            LazyOptional lazyOptional;
            TileEntity te;
            if (this.settings.get(direction) != WootMachineTileEntity.Mode.OUTPUT || !((te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction))) instanceof TileEntity) || !(lazyOptional = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())).isPresent()) continue;
            IFluidHandler iFluidHandler = (IFluidHandler)lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = this.outputTank.map(WootFluidTank::getFluid).orElse(FluidStack.EMPTY);
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.outputTank.ifPresent(f -> f.internalDrain(filled, IFluidHandler.FluidAction.EXECUTE));
            this.func_70296_d();
        }
    }

    private WootFluidTank createTank() {
        return new WootFluidTank((Integer)SqueezerConfiguration.ENCH_SQUEEZER_TANK_CAPACITY.get(), h -> h.isFluidEqual(new FluidStack((Fluid)FluidSetup.ENCHANT_FLUID.get(), 1))).setAccess(false, true);
    }

    public FluidStack getOutputTankFluid() {
        return this.outputTank.map(h -> h.getFluid()).orElse(FluidStack.EMPTY);
    }

    private WootEnergyStorage createEnergy() {
        return new WootEnergyStorage((Integer)SqueezerConfiguration.ENCH_SQUEEZER_MAX_ENERGY.get(), (Integer)SqueezerConfiguration.ENCH_SQUEEZER_MAX_ENERGY_RX.get());
    }

    public int getEnergy() {
        return this.energyStorage.map(h -> h.getEnergyStored()).orElse(0);
    }

    public void setEnergy(int v) {
        this.energyStorage.ifPresent(h -> h.setEnergy(v));
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.readfromNBT(compoundNBT);
        super.deserializeNBT(compoundNBT);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        this.readfromNBT(compoundNBT);
        super.func_230337_a_(blockState, compoundNBT);
    }

    public void readfromNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_150297_b("InputInventory", 9)) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inventory, null, (INBT)compoundNBT.func_150295_c("InputInventory", 10));
        }
        CompoundNBT tankTag = compoundNBT.func_74775_l("OutputTank");
        this.outputTank.ifPresent(h -> h.readFromNBT(tankTag));
        CompoundNBT energyTag = compoundNBT.func_74775_l("Energy");
        this.energyStorage.ifPresent(h -> h.deserializeNBT((INBT)energyTag));
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_218657_a("InputInventory", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inventory, null)));
        this.outputTank.ifPresent(h -> {
            CompoundNBT tankTag = h.writeToNBT(new CompoundNBT());
            compoundNBT.func_218657_a("OutputTank", (INBT)tankTag);
        });
        this.energyStorage.ifPresent(h -> {
            CompoundNBT energyTag = (CompoundNBT)h.serializeNBT();
            compoundNBT.func_218657_a("Energy", (INBT)energyTag);
        });
        return super.func_189515_b(compoundNBT);
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> EnchantSqueezerTileEntity");
        this.outputTank.ifPresent(h -> debug.add("     p:" + h.getFluidAmount()));
        debug.add("      Settings " + this.settings);
        return debug;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.woot.enchsqueezer.name");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new EnchantSqueezerContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyStorage.map(e -> e.getEnergyStored() > 0).orElse(false);
    }

    @Override
    protected int useEnergy() {
        return this.energyStorage.map(e -> e.extractEnergy((Integer)SqueezerConfiguration.ENCH_SQUEEZER_ENERGY_PER_TICK.get(), false)).orElse(0);
    }

    @Override
    protected int getRecipeEnergy() {
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT);
        if (itemStack.func_190926_b()) {
            return 0;
        }
        return this.getEnchantEnergy(itemStack);
    }

    @Override
    protected void clearRecipe() {
    }

    @Override
    protected void processFinish() {
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT);
        if (itemStack.func_190926_b()) {
            return;
        }
        this.inventory.extractItem(INPUT_SLOT, 1, false);
        int amount = this.getEnchantAmount(itemStack);
        this.outputTank.ifPresent(h -> h.internalFill(new FluidStack((Fluid)FluidSetup.ENCHANT_FLUID.get(), amount), IFluidHandler.FluidAction.EXECUTE));
        this.func_70296_d();
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.map(f -> f.getEnergyStored() <= 0).orElse(true).booleanValue()) {
            return false;
        }
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT);
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (!EnchantmentHelper.isEnchanted(itemStack)) {
            return false;
        }
        return this.outputTank.map(h -> {
            int filled;
            int amount = this.getEnchantAmount(itemStack);
            return amount == (filled = h.internalFill(new FluidStack((Fluid)FluidSetup.ENCHANT_FLUID.get(), amount), IFluidHandler.FluidAction.SIMULATE));
        }).orElse(false) != false;
    }

    @Override
    protected boolean hasValidInput() {
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT);
        return !itemStack.func_190926_b() && EnchantmentHelper.isEnchanted(itemStack);
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryGetter.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.outputTank.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    private int capEnchantAmount(int amount) {
        int max = SqueezerConfiguration.getEnchantFluidAmount(5);
        max *= 4;
        max = MathHelper.func_76125_a((int)max, (int)0, (int)((Integer)SqueezerConfiguration.ENCH_SQUEEZER_TANK_CAPACITY.get()));
        return MathHelper.func_76125_a((int)amount, (int)0, (int)max);
    }

    private int getEnchantAmount(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.func_190926_b() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListNBT listNBT = itemStack.func_77973_b() == Items.field_151134_bR ? EnchantedBookItem.func_92110_g((ItemStack)itemStack) : itemStack.func_77986_q();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT compoundNBT = listNBT.func_150305_b(i);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)compoundNBT.func_74779_i("id")));
                if (enchantment == null || !compoundNBT.func_74764_b("lvl")) continue;
                amount += SqueezerConfiguration.getEnchantFluidAmount(compoundNBT.func_74762_e("lvl"));
            }
        }
        return this.capEnchantAmount(amount);
    }

    private int getEnchantEnergy(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.func_190926_b() && EnchantmentHelper.isEnchanted(itemStack)) {
            ListNBT listNBT = itemStack.func_77973_b() == Items.field_151134_bR ? EnchantedBookItem.func_92110_g((ItemStack)itemStack) : itemStack.func_77986_q();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT compoundNBT = listNBT.func_150305_b(i);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)compoundNBT.func_74779_i("id")));
                if (enchantment == null || !compoundNBT.func_74764_b("lvl")) continue;
                amount += SqueezerConfiguration.getEnchantEnergy(compoundNBT.func_74762_e("lvl"));
            }
        }
        return amount;
    }

    public void dropContents(World world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT);
        if (!itemStack.func_190926_b()) {
            drops.add(itemStack);
            this.inventory.insertItem(INPUT_SLOT, ItemStack.field_190927_a, false);
        }
        super.dropContents(drops);
    }
}

