/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer;

import net.minecraftforge.common.ForgeConfigSpec;

public class SqueezerConfiguration {
    public static ForgeConfigSpec.IntValue DYE_SQUEEZER_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue DYE_SQUEEZER_INTERNAL_FLUID_MAX;
    public static ForgeConfigSpec.IntValue DYE_SQUEEZER_MAX_ENERGY;
    public static ForgeConfigSpec.IntValue DYE_SQUEEZER_MAX_ENERGY_RX;
    public static ForgeConfigSpec.IntValue DYE_SQUEEZER_ENERGY_PER_TICK;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_TANK_CAPACITY;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_MAX_ENERGY;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_MAX_ENERGY_RX;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_ENERGY_PER_TICK;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_1_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_2_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_3_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_4_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_5_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_EXTRA_ENCHANT_MB;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_1_ENERGY_COST;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_2_ENERGY_COST;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_3_ENERGY_COST;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_4_ENERGY_COST;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_LVL_5_ENERGY_COST;
    public static ForgeConfigSpec.IntValue ENCH_SQUEEZER_EXTRA_ENERGY_COST;

    public static void init(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        COMMON_BUILDER.comment("Settings for the squeezer").push("squeezer");
        CLIENT_BUILDER.comment("Settings for the squeezer").push("squeezer");
        COMMON_BUILDER.push("dye");
        DYE_SQUEEZER_TANK_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").defineInRange("tankCapacity", 4000, 0, Integer.MAX_VALUE);
        DYE_SQUEEZER_INTERNAL_FLUID_MAX = COMMON_BUILDER.comment("Internal tank capacity (mb)").defineInRange("internalTankCapacity", 7200, 0, Integer.MAX_VALUE);
        DYE_SQUEEZER_MAX_ENERGY = COMMON_BUILDER.comment("Energy capacity (mb)").defineInRange("energyCapacity", 10000, 0, Integer.MAX_VALUE);
        DYE_SQUEEZER_MAX_ENERGY_RX = COMMON_BUILDER.comment("Maximum energy that can be received (RF/t)").defineInRange("energyRxPerTick", 100, 0, Integer.MAX_VALUE);
        DYE_SQUEEZER_ENERGY_PER_TICK = COMMON_BUILDER.comment("Energy used per tick (RF)").defineInRange("energyUsePerTick", 40, 0, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("enchant");
        ENCH_SQUEEZER_TANK_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").defineInRange("tankCapacity", 10000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_MAX_ENERGY = COMMON_BUILDER.comment("Energy capacity (mb)").defineInRange("energyCapacity", 10000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_MAX_ENERGY_RX = COMMON_BUILDER.comment("Maximum energy that can be received (RF/t)").defineInRange("energyRxPerTick", 100, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_ENERGY_PER_TICK = COMMON_BUILDER.comment("Energy used per tick (RF)").defineInRange("energyUsePerTick", 40, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_1_ENCHANT_MB = COMMON_BUILDER.comment("Amount of fluid for a level I enchantment (in mb)").defineInRange("enchantAmountLevel1", 500, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_2_ENCHANT_MB = COMMON_BUILDER.comment("Amount of fluid for a level 2 enchantment (in mb)").defineInRange("enchantAmountLevel2", 1000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_3_ENCHANT_MB = COMMON_BUILDER.comment("Amount of fluid for a level 3 enchantment (in mb)").defineInRange("enchantAmountLevel3", 1500, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_4_ENCHANT_MB = COMMON_BUILDER.comment("Amount of fluid for a level 4 enchantment (in mb)").defineInRange("enchantAmountLevel4", 2000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_5_ENCHANT_MB = COMMON_BUILDER.comment("Amount of fluid for a level 5 enchantment (in mb)").defineInRange("enchantAmountLevel5", 2500, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_EXTRA_ENCHANT_MB = COMMON_BUILDER.comment("Amount of extra fluid for each level above 5 (in mb)").defineInRange("enchantAmountPerLevel", 500, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_1_ENERGY_COST = COMMON_BUILDER.comment("How much energy to process a level 1 enchanted item (in RF)").defineInRange("enchantEnergyLevel1", 1000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_2_ENERGY_COST = COMMON_BUILDER.comment("How much energy to process a level 2 enchanted item (in RF)").defineInRange("enchantEnergyLevel2", 2000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_3_ENERGY_COST = COMMON_BUILDER.comment("How much energy to process a level 3 enchanted item (in RF)").defineInRange("enchantEnergyLevel3", 3000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_4_ENERGY_COST = COMMON_BUILDER.comment("How much energy to process a level 4 enchanted item (in RF)").defineInRange("enchantEnergyLevel4", 4000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_LVL_5_ENERGY_COST = COMMON_BUILDER.comment("How much energy to process a level 5 enchanted item (in RF)").defineInRange("enchantEnergyLevel5", 5000, 0, Integer.MAX_VALUE);
        ENCH_SQUEEZER_EXTRA_ENERGY_COST = COMMON_BUILDER.comment("Amount of extra energy for each level above 5 (in RF)").defineInRange("enchantEnergyPerLevel", 1000, 0, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }

    public static int getEnchantFluidAmount(int level) {
        if (level <= 1) {
            return (Integer)ENCH_SQUEEZER_LVL_1_ENCHANT_MB.get();
        }
        if (level == 2) {
            return (Integer)ENCH_SQUEEZER_LVL_2_ENCHANT_MB.get();
        }
        if (level == 3) {
            return (Integer)ENCH_SQUEEZER_LVL_3_ENCHANT_MB.get();
        }
        if (level == 4) {
            return (Integer)ENCH_SQUEEZER_LVL_4_ENCHANT_MB.get();
        }
        if (level == 5) {
            return (Integer)ENCH_SQUEEZER_LVL_5_ENCHANT_MB.get();
        }
        return (Integer)ENCH_SQUEEZER_LVL_5_ENCHANT_MB.get() + (level -= 5) * (Integer)ENCH_SQUEEZER_EXTRA_ENCHANT_MB.get();
    }

    public static int getEnchantEnergy(int level) {
        if (level <= 1) {
            return (Integer)ENCH_SQUEEZER_LVL_1_ENERGY_COST.get();
        }
        if (level == 2) {
            return (Integer)ENCH_SQUEEZER_LVL_2_ENERGY_COST.get();
        }
        if (level == 3) {
            return (Integer)ENCH_SQUEEZER_LVL_3_ENERGY_COST.get();
        }
        if (level == 4) {
            return (Integer)ENCH_SQUEEZER_LVL_4_ENERGY_COST.get();
        }
        if (level == 5) {
            return (Integer)ENCH_SQUEEZER_LVL_5_ENERGY_COST.get();
        }
        return (Integer)ENCH_SQUEEZER_LVL_5_ENERGY_COST.get() + (level -= 5) * (Integer)ENCH_SQUEEZER_EXTRA_ENERGY_COST.get();
    }
}

