/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.generators;

import ipsis.woot.compat.reliquary.ReliquaryPlugin;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.generators.IndustrialForegoingGenerator;
import ipsis.woot.modules.factory.generators.ShardPerkData;
import ipsis.woot.modules.factory.generators.SkullGenerator;
import ipsis.woot.modules.factory.generators.WoolGenerator;
import ipsis.woot.modules.factory.items.XpShardBaseItem;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.modules.generic.items.GenericItem;
import ipsis.woot.policy.PolicyConfiguration;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import ipsis.woot.util.helper.RandomHelper;
import ipsis.woot.util.helper.StorageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootGeneration {
    static final Logger LOGGER = LogManager.getLogger();
    static final Random RANDOM = new Random();
    static final SkullGenerator SKULL_GENERATOR = new SkullGenerator();
    static LootGeneration INSTANCE = new LootGeneration();

    public static LootGeneration get() {
        return INSTANCE;
    }

    public void loadFromConfig() {
        SKULL_GENERATOR.loadFromConfig((List)PolicyConfiguration.MOB_PERK_HEADLESS_SKULLS.get());
    }

    public void generate(HeartTileEntity heartTileEntity, FormedSetup setup) {
        List<LazyOptional<IItemHandler>> itemHandlers = setup.getExportHandlers();
        List<LazyOptional<IFluidHandler>> fluidHandlers = setup.getExportFluidHandlers();
        int looting = setup.getLootingLevel();
        ArrayList<ItemStack> rolledDrops = new ArrayList<ItemStack>();
        for (FakeMob fakeMob : setup.getAllMobs()) {
            int mobCount = setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.MASS), setup.hasMassExotic());
            FakeMobKey fakeMobKey = new FakeMobKey(fakeMob, looting);
            for (int i = 0; i < mobCount; ++i) {
                rolledDrops.addAll(MobSimulator.getInstance().getRolledDrops(fakeMobKey));
            }
            ArrayList<ItemStack> charmStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : rolledDrops) {
                if (!ReliquaryPlugin.isCharmFragment(itemStack)) continue;
                itemStack.func_190920_e(0);
                ItemStack charmFragment = ReliquaryPlugin.getCharmFragment(fakeMobKey.getMob(), setup.getWorld());
                if (charmFragment.func_190926_b()) continue;
                charmStacks.add(charmFragment);
            }
            rolledDrops.addAll(charmStacks);
            for (ItemStack itemStack : rolledDrops) {
                if (itemStack.func_77984_f()) {
                    int dmg = RandomHelper.RANDOM.nextInt(itemStack.func_77958_k() + 1);
                    dmg = MathHelper.func_76125_a((int)dmg, (int)1, (int)itemStack.func_77958_k());
                    itemStack.func_196085_b(dmg);
                }
                if (!itemStack.func_77948_v()) continue;
                if (itemStack.func_77942_o()) {
                    itemStack.func_77978_p().func_82580_o("ench");
                }
                float f = setup.getWorld().func_175649_E(heartTileEntity.func_174877_v()).func_180170_c();
                boolean allowTreasure = false;
                EnchantmentHelper.func_77504_a((Random)RandomHelper.RANDOM, (ItemStack)itemStack, (int)((int)(5.0f + f * (float)RandomHelper.RANDOM.nextInt(18))), (boolean)allowTreasure);
            }
            if (!fakeMobKey.getMob().isSheep()) continue;
            for (ItemStack itemStack : rolledDrops) {
                if (!WoolGenerator.isWoolDrop(itemStack)) continue;
                itemStack.func_190920_e(0);
            }
            for (int i = 0; i < mobCount; ++i) {
                rolledDrops.add(WoolGenerator.getWoolDrop(fakeMobKey.getMob()));
            }
        }
        StorageHelper.insertItems(rolledDrops, itemHandlers);
        if (setup.getAllPerks().containsKey((Object)Perk.Group.XP)) {
            int genXp = 0;
            for (FakeMob mob : setup.getAllMobs()) {
                int xpPercent = setup.getAllMobParams().get(mob).getPerkXpValue();
                int mobCount = setup.getAllMobParams().get(mob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.MASS), setup.hasMassExotic());
                int x = (int)((float)SpawnController.get().getMobExperience(mob, setup.getWorld()) / 100.0f * (float)xpPercent);
                genXp += x * mobCount;
            }
            List<ItemStack> list = XpShardBaseItem.getShards(genXp);
            StorageHelper.insertItems(list, itemHandlers);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.TIER_SHARD)) {
            ArrayList<ShardPerkData> shards = new ArrayList<ShardPerkData>();
            shards.add(new ShardPerkData(GenericItem.GenericItemType.BASIC_UP_SHARD, setup.getBasicShardWeight()));
            shards.add(new ShardPerkData(GenericItem.GenericItemType.ADVANCED_UP_SHARD, setup.getAdvancedShardWeight()));
            shards.add(new ShardPerkData(GenericItem.GenericItemType.ELITE_UP_SHARD, setup.getEliteShardWeight()));
            int n = setup.getPerkTierShardValue();
            ArrayList<ItemStack> dropShards = new ArrayList<ItemStack>();
            for (int i = 0; i < n; ++i) {
                if (!RandomHelper.rollPercentage(setup.getShardDropChance(), "shardGen")) continue;
                ShardPerkData chosenShard = (ShardPerkData)WeightedRandom.func_76271_a((Random)RANDOM, shards);
                dropShards.add(chosenShard.getItemStack());
            }
            StorageHelper.insertItems(dropShards, itemHandlers);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.HEADLESS)) {
            ArrayList<ItemStack> skulls = new ArrayList<ItemStack>();
            List<FakeMob> list = setup.getAllMobs().stream().map(m -> {
                int mobCount = setup.getAllMobParams().get(m).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.MASS), setup.hasMassExotic());
                return Collections.nCopies(mobCount, m);
            }).flatMap(Collection::stream).collect(Collectors.toList());
            list.forEach(m -> skulls.add(SKULL_GENERATOR.getSkullDrop((FakeMob)m, setup.getAllMobParams().get(m).getPerkHeadlessValue())));
            StorageHelper.insertItems(skulls, itemHandlers);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.SLAUGHTER) || setup.getAllPerks().containsKey((Object)Perk.Group.CRUSHER) || setup.getAllPerks().containsKey((Object)Perk.Group.LASER)) {
            IndustrialForegoingGenerator.GeneratedFluids fluids = IndustrialForegoingGenerator.getFluids(setup, setup.getWorld());
            if (setup.getAllPerks().containsKey((Object)Perk.Group.SLAUGHTER) && !fluids.meat.isEmpty() && !fluids.pink.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.meat);
                arrayList.add(fluids.pink);
                StorageHelper.insertFluids(arrayList, fluidHandlers);
            }
            if (setup.getAllPerks().containsKey((Object)Perk.Group.CRUSHER) && !fluids.essence.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.essence);
                StorageHelper.insertFluids(arrayList, fluidHandlers);
            }
            if (setup.getAllPerks().containsKey((Object)Perk.Group.LASER) && !fluids.ether.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.ether);
                StorageHelper.insertFluids(arrayList, fluidHandlers);
            }
        }
    }
}

