/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.blocks.HeartContainer;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.setup.ServerDataRequest;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class HeartScreen
extends WootContainerScreen<HeartContainer> {
    private ResourceLocation GUI = new ResourceLocation("woot", "textures/gui/heart.png");
    private List<GuiItemStackElement> dropElements = new ArrayList<GuiItemStackElement>();
    private List<GuiItemStackElement> mobElements = new ArrayList<GuiItemStackElement>();
    private List<GuiItemStackElement> upgradeElements = new ArrayList<GuiItemStackElement>();
    private List<GuiStackElement> recipeElements = new ArrayList<GuiStackElement>();
    private StackElement exoticElement = new StackElement(EXOTIC_X, EXOTIC_Y);
    private int GUI_WIDTH = 252;
    private int GUI_HEIGHT = 222;
    private int DROPS_COLS = 13;
    private int DROPS_ROWS = 4;
    private int DROPS_X = 10;
    private int DROPS_Y = 144;
    private int MOBS_X = 10;
    private int MOBS_Y = 76;
    private int PERKS_X = 99;
    private int PERKS_Y = 76;
    private int RECIPE_X = 10;
    private int RECIPE_Y = 110;
    private float DROP_CYCLE_MS = 5000.0f;
    private int TEXT_COLOR = 0x404040;
    private static final int TANK_LX = 226;
    private static final int TANK_LY = 8;
    private static final int TANK_RX = 241;
    private static final int TANK_RY = 91;
    private static int EXOTIC_X = 190;
    private static int EXOTIC_Y = 76;
    private long renderTime;
    private boolean sync = false;

    public HeartScreen(HeartContainer container, PlayerInventory inv, ITextComponent name) {
        super(container, inv, name);
        this.field_146999_f = this.GUI_WIDTH;
        this.field_147000_g = this.GUI_HEIGHT;
    }

    protected void func_231160_c_() {
        int i;
        super.func_231160_c_();
        for (i = 0; i < 4; ++i) {
            this.mobElements.add(new GuiItemStackElement(this.MOBS_X + i * 18, this.MOBS_Y, true));
        }
        for (i = 0; i < 4; ++i) {
            this.upgradeElements.add(new GuiItemStackElement(this.PERKS_X + i * 18, this.PERKS_Y, true));
        }
        for (int row = 0; row < this.DROPS_ROWS; ++row) {
            for (int col = 0; col < this.DROPS_COLS; ++col) {
                this.dropElements.add(new GuiItemStackElement(this.DROPS_X + col * 18, this.DROPS_Y + row * 18));
            }
        }
        NetworkChannel.channel.sendToServer((Object)new ServerDataRequest(ServerDataRequest.Type.HEART_STATIC_DATA, ((HeartContainer)this.field_147002_h).getPos(), ""));
    }

    private int getCapacity() {
        int capacity = 0;
        if (((HeartContainer)this.field_147002_h).getCellType() == 0) {
            capacity = (Integer)FactoryConfiguration.CELL_1_CAPACITY.get();
        } else if (((HeartContainer)this.field_147002_h).getCellType() == 1) {
            capacity = (Integer)FactoryConfiguration.CELL_2_CAPACITY.get();
        } else if (((HeartContainer)this.field_147002_h).getCellType() == 2) {
            capacity = (Integer)FactoryConfiguration.CELL_3_CAPACITY.get();
        } else if (((HeartContainer)this.field_147002_h).getCellType() == 3) {
            capacity = (Integer)FactoryConfiguration.CELL_4_CAPACITY.get();
        }
        return capacity;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.mobElements.forEach(e -> e.drawTooltip(matrixStack, mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawTooltip(matrixStack, mouseX, mouseY));
        this.dropElements.forEach(e -> e.drawTooltip(matrixStack, mouseX, mouseY));
        this.recipeElements.forEach(e -> e.drawTooltip(matrixStack, mouseX, mouseY));
        this.exoticElement.drawTooltip(matrixStack, mouseX, mouseY);
        if (this.renderTime == 0L) {
            this.renderTime = Util.func_211177_b();
        }
        if (mouseX > this.field_147003_i + 226 && mouseX < this.field_147003_i + 241 && mouseY > this.field_147009_r + 8 && mouseY < this.field_147009_r + 91) {
            this.renderFluidTankTooltip(matrixStack, mouseX, mouseY, ((HeartContainer)this.field_147002_h).getInputFluid(), this.getCapacity());
        }
    }

    private boolean addToDropElements(int idx, FakeMob fakeMob, ItemStack itemStack) {
        List tooltip = this.func_231151_a_(itemStack);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
        if (entityType != null) {
            TranslationTextComponent iTextComponent = new TranslationTextComponent(entityType.func_210760_d());
            tooltip.add(new StringTextComponent(String.format("%s : %.2f%%", iTextComponent.getString(), Float.valueOf((float)itemStack.func_190916_E() / 100.0f))));
        }
        boolean found = false;
        for (GuiItemStackElement guiItemStackElement : this.dropElements) {
            if (!guiItemStackElement.itemStack.func_77969_a(itemStack)) continue;
            guiItemStackElement.addToolTip(tooltip);
            found = true;
            break;
        }
        if (!found) {
            this.dropElements.get(idx).setItemStack(itemStack);
            this.dropElements.get(idx).addToolTip(tooltip);
            return true;
        }
        return false;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ClientFactorySetup clientFactorySetup = ((HeartContainer)this.field_147002_h).getTileEntity().clientFactorySetup;
        if (clientFactorySetup == null) {
            return;
        }
        if (!this.sync) {
            GuiStackElement stackElement;
            ArrayList<ITextComponent> tooltip;
            int idx = 0;
            ArrayList<FakeMob> knownMobs = new ArrayList<FakeMob>();
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                if (knownMobs.contains(fakeMob)) continue;
                knownMobs.add(fakeMob);
                ClientFactorySetup.Mob mobInfo = clientFactorySetup.mobInfo.get(fakeMob);
                for (ItemStack itemStack : mobInfo.drops) {
                    if (!this.addToDropElements(idx, fakeMob, itemStack)) continue;
                    idx = (idx + 1) % this.dropElements.size();
                }
            }
            if (clientFactorySetup.tier != Tier.TIER_1) {
                for (int i = 0; i < 4; ++i) {
                    this.mobElements.get(i).unlock();
                    this.upgradeElements.get(i).unlock();
                }
            } else {
                this.mobElements.get(0).unlock();
                this.upgradeElements.get(0).unlock();
            }
            idx = 0;
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                ItemStack controllerStack = ControllerTileEntity.getItemStack(fakeMob);
                tooltip = this.func_231151_a_(controllerStack);
                this.mobElements.get(idx).setItemStack(controllerStack);
                this.mobElements.get(idx).addToolTip((List<ITextComponent>)tooltip);
                this.mobElements.get(idx).unlock();
                ++idx;
            }
            idx = 0;
            for (Perk perk : clientFactorySetup.perks) {
                ItemStack itemStack = PerkItem.getItemStack(perk);
                tooltip = this.func_231151_a_(itemStack);
                for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                    MobParam mobParam = clientFactorySetup.mobParams.get(fakeMob);
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
                    if (entityType == null) continue;
                    TranslationTextComponent iTextComponent = new TranslationTextComponent(entityType.func_210760_d());
                    if (Perk.EFFICIENCY_PERKS.contains((Object)perk)) {
                        tooltip.add((ITextComponent)new StringTextComponent(String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkEfficiencyValue())));
                        continue;
                    }
                    if (Perk.RATE_PERKS.contains((Object)perk)) {
                        tooltip.add((ITextComponent)new StringTextComponent(String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkRateValue())));
                        continue;
                    }
                    if (Perk.MASS_PERKS.contains((Object)perk)) {
                        tooltip.add((ITextComponent)new StringTextComponent(String.format("%s : %d mobs", iTextComponent.getString(), mobParam.getMobCount(true, clientFactorySetup.exotic == Exotic.EXOTIC_E))));
                        continue;
                    }
                    if (!Perk.XP_PERKS.contains((Object)perk)) continue;
                    tooltip.add((ITextComponent)new StringTextComponent(String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkXpValue())));
                }
                if (Perk.TIER_SHARD_PERKS.contains((Object)perk)) {
                    tooltip.add((ITextComponent)new StringTextComponent(String.format("%d rolls @ %.2f%%", clientFactorySetup.shardRolls, clientFactorySetup.shardDropChance)));
                    tooltip.add((ITextComponent)new StringTextComponent(String.format("Basic: %.2f%%", clientFactorySetup.shardDrops[0])));
                    tooltip.add((ITextComponent)new StringTextComponent(String.format("Advanced: %.2f%%", clientFactorySetup.shardDrops[1])));
                    tooltip.add((ITextComponent)new StringTextComponent(String.format("Elite: %.2f%%", clientFactorySetup.shardDrops[2])));
                }
                if (clientFactorySetup.perkCapped) {
                    TranslationTextComponent translationTextComponent = new TranslationTextComponent(clientFactorySetup.tier.getTranslationKey());
                    TranslationTextComponent iTextComponent2 = new TranslationTextComponent("gui.woot.heart.8");
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + String.format("%s : %s", iTextComponent2.getString(), translationTextComponent.getString())));
                }
                this.upgradeElements.get(idx).setItemStack(itemStack);
                this.upgradeElements.get(idx).addToolTip(tooltip);
                this.upgradeElements.get(idx).unlock();
                idx = (idx + 1) % this.upgradeElements.size();
            }
            idx = 0;
            for (ItemStack itemStack : clientFactorySetup.itemIng) {
                stackElement = new GuiItemStackElement(this.RECIPE_X + idx * 18, this.RECIPE_Y);
                tooltip = this.func_231151_a_(itemStack);
                tooltip.add((ITextComponent)new StringTextComponent(String.format("%d items", itemStack.func_190916_E())));
                ((GuiItemStackElement)stackElement).setItemStack(itemStack.func_77946_l());
                ((GuiItemStackElement)stackElement).addToolTip(tooltip);
                this.recipeElements.add(stackElement);
                ++idx;
            }
            for (FluidStack fluidStack : clientFactorySetup.fluidIng) {
                stackElement = new GuiFluidStackElement(this.RECIPE_X + idx * 18, this.RECIPE_Y);
                tooltip = new ArrayList<ITextComponent>();
                tooltip.add(fluidStack.getDisplayName());
                tooltip.add((ITextComponent)new StringTextComponent(String.format("%d mb", fluidStack.getAmount())));
                ((GuiFluidStackElement)stackElement).setStack(fluidStack.copy());
                ((GuiFluidStackElement)stackElement).addTooltip(tooltip);
                this.recipeElements.add(stackElement);
                ++idx;
            }
            this.sync = true;
        }
        if (clientFactorySetup.tier != Tier.TIER_5) {
            this.exoticElement.isLocked = true;
        } else if (clientFactorySetup.exotic != Exotic.NONE) {
            List tooltip = this.func_231151_a_(clientFactorySetup.exotic.getItemStack());
            this.exoticElement.addDrop(clientFactorySetup.exotic.getItemStack(), tooltip);
        }
        this.addInfoLine(matrixStack, 0, StringHelper.translate("gui.woot.heart.0"), this.field_230704_d_.getString());
        this.addInfoLine(matrixStack, 1, StringHelper.translate(new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), 1).getTranslationKey()), clientFactorySetup.recipeFluid + " mB");
        this.addInfoLine(matrixStack, 2, StringHelper.translate("gui.woot.heart.1"), clientFactorySetup.recipeTicks + " ticks");
        this.addInfoLine(matrixStack, 3, StringHelper.translate("gui.woot.heart.2"), ((HeartContainer)this.field_147002_h).getProgress() + "%");
        this.field_230712_o_.func_238421_b_(matrixStack, StringHelper.translate("gui.woot.heart.3"), (float)this.MOBS_X, (float)(this.MOBS_Y - 10), this.TEXT_COLOR);
        this.field_230712_o_.func_238421_b_(matrixStack, StringHelper.translate("gui.woot.heart.4"), (float)this.PERKS_X, (float)(this.PERKS_Y - 10), this.TEXT_COLOR);
        this.field_230712_o_.func_238421_b_(matrixStack, StringHelper.translate("gui.woot.heart.5"), (float)this.DROPS_X, (float)(this.DROPS_Y - 10), this.TEXT_COLOR);
        this.field_230712_o_.func_238421_b_(matrixStack, StringHelper.translate("gui.woot.heart.6"), (float)this.RECIPE_X, (float)(this.RECIPE_Y - 10), this.TEXT_COLOR);
        this.field_230712_o_.func_238421_b_(matrixStack, StringHelper.translate("gui.woot.heart.7"), (float)EXOTIC_X, (float)(EXOTIC_Y - 10), this.TEXT_COLOR);
        this.mobElements.forEach(e -> e.drawForeground(matrixStack, mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawForeground(matrixStack, mouseX, mouseY));
        this.recipeElements.forEach(e -> e.drawForeground(matrixStack, mouseX, mouseY));
        this.dropElements.forEach(e -> e.drawForeground(matrixStack, mouseX, mouseY));
        this.exoticElement.drawForeground(matrixStack, mouseX, mouseY);
    }

    private void addInfoLine(MatrixStack matrixStack, int offset, String tag, String value) {
        int INFO_X = 10;
        int INFO_Y = 10;
        int TEXT_HEIGHT = 10;
        this.field_230712_o_.func_238421_b_(matrixStack, tag, (float)INFO_X, (float)(INFO_Y + TEXT_HEIGHT * offset), this.TEXT_COLOR);
        this.field_230712_o_.func_238421_b_(matrixStack, value, (float)(INFO_X + 80), (float)(INFO_Y + TEXT_HEIGHT * offset), this.TEXT_COLOR);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int relY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.mobElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.dropElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.recipeElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.exoticElement.drawBackground(mouseX, mouseY);
        this.renderFluidTank(matrixStack, 226, 91, 84, 16, this.getCapacity(), ((HeartContainer)this.field_147002_h).getInputFluid());
    }

    public class GuiFluidStackElement
    extends GuiStackElement {
        private FluidStack fluidStack;
        private List<ITextComponent> tooltip;

        public GuiFluidStackElement(int posX, int posY, boolean isLocked) {
            super(posX, posY, isLocked);
            this.tooltip = new ArrayList<ITextComponent>();
            this.fluidStack = FluidStack.EMPTY;
        }

        public GuiFluidStackElement(int posX, int posY) {
            super(posX, posY);
            this.tooltip = new ArrayList<ITextComponent>();
            this.fluidStack = FluidStack.EMPTY;
        }

        public void setStack(FluidStack fluidStack) {
            this.fluidStack = fluidStack.copy();
        }

        public void addTooltip(List<ITextComponent> tooltip) {
            this.tooltip.addAll(tooltip);
        }

        @Override
        public void drawBackground(int mouseX, int mouseY) {
            if (this.isLocked || this.fluidStack.isEmpty()) {
                return;
            }
            HeartScreen.this.drawFluid(HeartScreen.this.field_147003_i + this.posX, HeartScreen.this.field_147009_r + this.posY, this.fluidStack, 16, 16);
        }

        @Override
        public void drawForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
            super.drawForeground(matrixStack, mouseX, mouseY);
        }

        @Override
        public void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.isLocked || this.fluidStack.isEmpty() || this.tooltip.isEmpty()) {
                return;
            }
            if (!HeartScreen.this.func_195359_a(this.posX, this.posY, 16, 16, mouseX, mouseY)) {
                return;
            }
            HeartScreen.this.func_243308_b(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public class GuiItemStackElement
    extends GuiStackElement {
        private ItemStack itemStack;
        List<ITextComponent> tooltip;

        public GuiItemStackElement(int posX, int posY, boolean isLocked) {
            super(posX, posY, isLocked);
            this.tooltip = new ArrayList<ITextComponent>();
            this.itemStack = ItemStack.field_190927_a;
        }

        public GuiItemStackElement(int posX, int posY) {
            super(posX, posY);
            this.tooltip = new ArrayList<ITextComponent>();
            this.itemStack = ItemStack.field_190927_a;
        }

        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack.func_77946_l();
        }

        public void addToolTip(List<ITextComponent> tooltip) {
            this.tooltip.addAll(tooltip);
        }

        @Override
        public void drawBackground(int mouseX, int mouseY) {
            if (this.isLocked || this.itemStack.func_190926_b()) {
                return;
            }
        }

        @Override
        public void drawForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
            super.drawForeground(matrixStack, mouseX, mouseY);
            if (this.itemStack.func_190926_b()) {
                return;
            }
            HeartScreen.this.func_230926_e_(100);
            ((HeartScreen)HeartScreen.this).field_230707_j_.field_77023_b = 100.0f;
            RenderHelper.func_227780_a_();
            GlStateManager.func_227734_k_();
            HeartScreen.this.field_230707_j_.func_175042_a(this.itemStack, this.posX, this.posY);
            RenderHelper.func_74518_a();
            ((HeartScreen)HeartScreen.this).field_230707_j_.field_77023_b = 0.0f;
            HeartScreen.this.func_230926_e_(0);
        }

        @Override
        public void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.isLocked || this.itemStack.func_190926_b() || this.tooltip.isEmpty()) {
                return;
            }
            if (!HeartScreen.this.func_195359_a(this.posX, this.posY, 16, 16, mouseX, mouseY)) {
                return;
            }
            HeartScreen.this.func_243308_b(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    class GuiStackElement {
        int posX;
        int posY;
        boolean isLocked = false;

        public GuiStackElement() {
        }

        public GuiStackElement(int posX, int posY) {
            this();
            this.posX = posX;
            this.posY = posY;
        }

        public GuiStackElement(int posX, int posY, boolean isLocked) {
            this(posX, posY);
            this.isLocked = isLocked;
        }

        public void unlock() {
            this.isLocked = false;
        }

        public void lock() {
            this.isLocked = true;
        }

        public void drawBackground(int mouseX, int mouseY) {
        }

        public void drawForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.isLocked) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.posX - 1), (int)(this.posY - 1), (int)(this.posX - 1 + 18), (int)(this.posY - 1 + 18), (int)-2130706433);
            }
        }

        public void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
        }
    }

    class StackElement {
        int x;
        int y;
        boolean isLocked = false;
        int idx = 0;
        List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<List<ITextComponent>> tooltips = new ArrayList<List<ITextComponent>>();

        public StackElement(int x, int y, boolean locked) {
            this.x = x;
            this.y = y;
            this.isLocked = locked;
        }

        public StackElement(int x, int y) {
            this(x, y, false);
        }

        public void addDrop(ItemStack itemStack, List<ITextComponent> tooltip) {
            this.isLocked = false;
            this.itemStacks.add(itemStack);
            this.tooltips.add(tooltip);
        }

        public void unlock() {
            this.isLocked = false;
        }

        public void cycle() {
            if (!this.itemStacks.isEmpty()) {
                this.idx = (this.idx + 1) % this.itemStacks.size();
            }
        }

        public void drawBackground(int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
        }

        public void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            List<ITextComponent> tooltip = this.tooltips.get(this.idx);
            if (HeartScreen.this.func_195359_a(this.x, this.y, 16, 16, mouseX, mouseY)) {
                FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
                HeartScreen.this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
            }
        }

        public void drawForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.isLocked) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (int)(this.x - 1 + 18), (int)(this.y - 1 + 18), (int)-2130706433);
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            HeartScreen.this.func_230926_e_(100);
            ((HeartScreen)HeartScreen.this).field_230707_j_.field_77023_b = 100.0f;
            RenderHelper.func_227780_a_();
            GlStateManager.func_227734_k_();
            HeartScreen.this.field_230707_j_.func_175042_a(itemStack, this.x, this.y);
            RenderHelper.func_74518_a();
            ((HeartScreen)HeartScreen.this).field_230707_j_.field_77023_b = 0.0f;
            HeartScreen.this.func_230926_e_(0);
        }
    }
}

