/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.multiblock.MultiBlockTileEntity;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class ControllerTileEntity
extends MultiBlockTileEntity
implements WootDebug {
    private FakeMob fakeMob = new FakeMob();

    public ControllerTileEntity() {
        super((TileEntityType)FactorySetup.CONTROLLER_BLOCK_TILE.get());
    }

    public void deserializeNBT(CompoundNBT compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.readFromNBT(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        CompoundNBT nbt = new CompoundNBT();
        FakeMob.writeToNBT(this.fakeMob, nbt);
        compoundNBT.func_218657_a("Mob", (INBT)nbt);
        return compoundNBT;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        super.func_230337_a_(blockState, compoundNBT);
        this.readFromNBT(compoundNBT);
    }

    private void readFromNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("Mob")) {
            CompoundNBT nbt = compoundNBT.func_74775_l("Mob");
            this.fakeMob = new FakeMob(nbt);
        }
    }

    public FakeMob getFakeMob() {
        return this.fakeMob;
    }

    public Tier getTier() {
        if (this.fakeMob == null || !this.fakeMob.isValid()) {
            return Tier.UNKNOWN;
        }
        return Config.OVERRIDE.getMobTier(this.fakeMob, this.field_145850_b);
    }

    public static ItemStack getItemStack(FakeMob fakeMob) {
        ItemStack itemStack = new ItemStack((IItemProvider)FactorySetup.CONTROLLER_BLOCK.get());
        CompoundNBT compoundNBT = itemStack.func_190925_c("BlockEntityTag");
        CompoundNBT nbt = new CompoundNBT();
        FakeMob.writeToNBT(fakeMob, nbt);
        compoundNBT.func_218657_a("Mob", (INBT)nbt);
        return itemStack;
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> ControllerTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      mob: " + this.fakeMob);
        return debug;
    }
}

