/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.config.ConfigDefaults;
import ipsis.woot.modules.factory.perks.Perk;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class FactoryConfiguration {
    public static ForgeConfigSpec.BooleanValue TICK_ACCEL;
    public static ForgeConfigSpec.IntValue CELL_1_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_1_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_2_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_2_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_3_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_3_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_4_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_4_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue MASS_COUNT;
    public static ForgeConfigSpec.IntValue SPAWN_TICKS;
    public static ForgeConfigSpec.IntValue UNITS_PER_HEALTH;
    public static ForgeConfigSpec.IntValue MOB_SHARD_KILLS;
    public static ForgeConfigSpec.IntValue TIER_1_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_2_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_3_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_4_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_5_MAX_UNITS;
    public static ForgeConfigSpec.DoubleValue EXOTIC_A;
    public static ForgeConfigSpec.DoubleValue EXOTIC_B;
    public static ForgeConfigSpec.DoubleValue EXOTIC_C;
    public static ForgeConfigSpec.IntValue EXOTIC_D;
    public static ForgeConfigSpec.IntValue EXOTIC_E;
    public static ForgeConfigSpec.DoubleValue EXOTIC;
    public static ForgeConfigSpec.IntValue EFFICIENCY_1;
    public static ForgeConfigSpec.IntValue EFFICIENCY_2;
    public static ForgeConfigSpec.IntValue EFFICIENCY_3;
    public static ForgeConfigSpec.IntValue MASS_COUNT_1;
    public static ForgeConfigSpec.IntValue MASS_COUNT_2;
    public static ForgeConfigSpec.IntValue MASS_COUNT_3;
    public static ForgeConfigSpec.IntValue RATE_1;
    public static ForgeConfigSpec.IntValue RATE_2;
    public static ForgeConfigSpec.IntValue RATE_3;
    public static ForgeConfigSpec.IntValue XP_1;
    public static ForgeConfigSpec.IntValue XP_2;
    public static ForgeConfigSpec.IntValue XP_3;
    public static ForgeConfigSpec.IntValue TIER_SHARD_1;
    public static ForgeConfigSpec.IntValue TIER_SHARD_2;
    public static ForgeConfigSpec.IntValue TIER_SHARD_3;
    public static ForgeConfigSpec.IntValue HEADLESS_1;
    public static ForgeConfigSpec.IntValue HEADLESS_2;
    public static ForgeConfigSpec.IntValue HEADLESS_3;
    public static ForgeConfigSpec.IntValue SLAUGHTER_1;
    public static ForgeConfigSpec.IntValue SLAUGHTER_2;
    public static ForgeConfigSpec.IntValue SLAUGHTER_3;
    public static ForgeConfigSpec.IntValue CRUSHER_1;
    public static ForgeConfigSpec.IntValue CRUSHER_2;
    public static ForgeConfigSpec.IntValue CRUSHER_3;
    public static ForgeConfigSpec.IntValue LASER_1;
    public static ForgeConfigSpec.IntValue LASER_2;
    public static ForgeConfigSpec.IntValue LASER_3;
    public static ForgeConfigSpec.IntValue FLAYED_1;
    public static ForgeConfigSpec.IntValue FLAYED_2;
    public static ForgeConfigSpec.IntValue FLAYED_3;
    public static ForgeConfigSpec.DoubleValue T1_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T1_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T2_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T2_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T3_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T3_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T4_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T4_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T5_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T5_FARM_DROP_SHARD_WEIGHTS;

    public static ForgeConfigSpec.IntValue getPerkIntValue(Perk.Group group, int level) {
        if (group == Perk.Group.EFFICIENCY && level == 1) {
            return EFFICIENCY_1;
        }
        if (group == Perk.Group.EFFICIENCY && level == 2) {
            return EFFICIENCY_2;
        }
        if (group == Perk.Group.EFFICIENCY && level == 3) {
            return EFFICIENCY_3;
        }
        if (group == Perk.Group.MASS && level == 1) {
            return MASS_COUNT_1;
        }
        if (group == Perk.Group.MASS && level == 2) {
            return MASS_COUNT_2;
        }
        if (group == Perk.Group.MASS && level == 3) {
            return MASS_COUNT_3;
        }
        if (group == Perk.Group.RATE && level == 1) {
            return RATE_1;
        }
        if (group == Perk.Group.RATE && level == 2) {
            return RATE_2;
        }
        if (group == Perk.Group.RATE && level == 3) {
            return RATE_3;
        }
        if (group == Perk.Group.TIER_SHARD && level == 1) {
            return TIER_SHARD_1;
        }
        if (group == Perk.Group.TIER_SHARD && level == 2) {
            return TIER_SHARD_2;
        }
        if (group == Perk.Group.TIER_SHARD && level == 3) {
            return TIER_SHARD_3;
        }
        if (group == Perk.Group.XP && level == 1) {
            return XP_1;
        }
        if (group == Perk.Group.XP && level == 1) {
            return XP_2;
        }
        if (group == Perk.Group.XP && level == 1) {
            return XP_3;
        }
        if (group == Perk.Group.HEADLESS && level == 1) {
            return HEADLESS_1;
        }
        if (group == Perk.Group.HEADLESS && level == 2) {
            return HEADLESS_2;
        }
        if (group == Perk.Group.HEADLESS && level == 3) {
            return HEADLESS_3;
        }
        if (group == Perk.Group.SLAUGHTER && level == 1) {
            return SLAUGHTER_1;
        }
        if (group == Perk.Group.SLAUGHTER && level == 2) {
            return SLAUGHTER_2;
        }
        if (group == Perk.Group.SLAUGHTER && level == 3) {
            return SLAUGHTER_3;
        }
        if (group == Perk.Group.CRUSHER && level == 1) {
            return CRUSHER_1;
        }
        if (group == Perk.Group.CRUSHER && level == 2) {
            return CRUSHER_2;
        }
        if (group == Perk.Group.CRUSHER && level == 3) {
            return CRUSHER_3;
        }
        if (group == Perk.Group.LASER && level == 1) {
            return LASER_1;
        }
        if (group == Perk.Group.LASER && level == 2) {
            return LASER_2;
        }
        if (group == Perk.Group.LASER && level == 3) {
            return LASER_3;
        }
        if (group == Perk.Group.FLAYED && level == 1) {
            return FLAYED_1;
        }
        if (group == Perk.Group.FLAYED && level == 2) {
            return FLAYED_2;
        }
        if (group == Perk.Group.FLAYED && level == 3) {
            return FLAYED_3;
        }
        return null;
    }

    public static void init(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        COMMON_BUILDER.comment("Settings for the factory").push("factory");
        CLIENT_BUILDER.comment("Settings for the factory").push("factory");
        COMMON_BUILDER.push("general");
        TICK_ACCEL = COMMON_BUILDER.comment("Allow tick acceleration to be used on the factory").define("tickAcceleration", true);
        TIER_1_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 1 mob").defineInRange("t1MaxHealth", 20, 5, Integer.MAX_VALUE);
        TIER_2_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 2 mob").defineInRange("t2MaxHealth", 40, 5, Integer.MAX_VALUE);
        TIER_3_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 3 mob").defineInRange("t3MaxHealth", 60, 5, Integer.MAX_VALUE);
        TIER_4_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 4 mob").defineInRange("t4MaxHealth", Integer.MAX_VALUE, 5, Integer.MAX_VALUE);
        TIER_5_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 5 mob").defineInRange("t5MaxHealth", Integer.MAX_VALUE, 5, Integer.MAX_VALUE);
        EXOTIC = COMMON_BUILDER.comment("Exotic drop chance").defineInRange("exotic", 15.0, 0.0, 100.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("base");
        MASS_COUNT = COMMON_BUILDER.comment("Number of mobs to spawn").defineInRange("massCount", 1, 1, 100);
        SPAWN_TICKS = COMMON_BUILDER.comment("Number of ticks to spawn a mob").defineInRange("spawnTicks", 320, 1, 65535);
        UNITS_PER_HEALTH = COMMON_BUILDER.comment("Number of units for each health").defineInRange("mbPerHealth", 10, 1, 65535);
        MOB_SHARD_KILLS = COMMON_BUILDER.comment("Number of kills to program the shard").defineInRange("shardKills", 5, 1, 65535);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("basicCell");
        CELL_1_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 10000, 1, Integer.MAX_VALUE);
        CELL_1_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 1000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("advancedCell");
        CELL_2_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 50000, 1, Integer.MAX_VALUE);
        CELL_2_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 5000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("premiumCell");
        CELL_3_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 100000, 1, Integer.MAX_VALUE);
        CELL_3_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 10000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("ultimateCell");
        CELL_4_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 1000000, 1, Integer.MAX_VALUE);
        CELL_4_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 25000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("exotic");
        EXOTIC_A = COMMON_BUILDER.comment("Percentage reduction for recipe fluids").defineInRange("exoticAPercentage", 85.0, 0.0, 100.0);
        EXOTIC_B = COMMON_BUILDER.comment("Percentage reduction for recipe fluids").defineInRange("exoticBPercentage", 85.0, 0.0, 100.0);
        EXOTIC_C = COMMON_BUILDER.comment("Percentage reduction for Conatus fluid").defineInRange("exoticCPercentage", 85.0, 0.0, 100.0);
        EXOTIC_D = COMMON_BUILDER.comment("Number of ticks between spawns").defineInRange("exoticDTicks", 20, 1, Integer.MAX_VALUE);
        EXOTIC_E = COMMON_BUILDER.comment("Number of mobs to spawn").defineInRange("exoticECount", 10, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("perks");
        COMMON_BUILDER.push("efficiency");
        EFFICIENCY_1 = COMMON_BUILDER.comment("Percentage reduction for efficiency 1 perks").defineInRange("l1Reduction", 15, 0, 100);
        EFFICIENCY_2 = COMMON_BUILDER.comment("Percentage reduction for efficiency 2 perks").defineInRange("l2Reduction", 25, 0, 100);
        EFFICIENCY_3 = COMMON_BUILDER.comment("Percentage reduction for efficiency 3 perks").defineInRange("l3Reduction", 30, 0, 100);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("mass");
        MASS_COUNT_1 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 1 perks").defineInRange("l1MobCount", 2, 1, 100);
        MASS_COUNT_2 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 2 perks").defineInRange("l2MobCount", 4, 1, 100);
        MASS_COUNT_3 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 3 perks").defineInRange("l3MobCount", 6, 1, 100);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("rate");
        RATE_1 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 1 perks").defineInRange("l1Reduction", 20, 1, 99);
        RATE_2 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 2 perks").defineInRange("l2Reduction", 50, 1, 99);
        RATE_3 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 3 perks").defineInRange("l3Reduction", 75, 1, 99);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("tierShard");
        TIER_SHARD_1 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 1 perk").defineInRange("l1Rolls", 1, 0, Integer.MAX_VALUE);
        TIER_SHARD_2 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 2 perk").defineInRange("l2Rolls", 2, 0, Integer.MAX_VALUE);
        TIER_SHARD_3 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 3 perk").defineInRange("l3Rolls", 3, 0, Integer.MAX_VALUE);
        T1_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 1 factory").defineInRange("t1DropChance", 5.0, 0.0, 100.0);
        T2_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 2 factory").defineInRange("t2DropChance", 10.0, 0.0, 100.0);
        T3_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 3 factory").defineInRange("t3DropChance", 20.0, 0.0, 100.0);
        T4_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 4 factory").defineInRange("t4DropChance", 30.0, 0.0, 100.0);
        T5_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 5 factory").defineInRange("t5DropChance", 40.0, 0.0, 100.0);
        T1_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 1 factory").define("t1DropWeights", ConfigDefaults.Factory.T1_SHARD_DROP_WEIGHTS_DEF);
        T2_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 2 factory").define("t2DropWeights", ConfigDefaults.Factory.T2_SHARD_DROP_WEIGHTS_DEF);
        T3_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 3 factory").define("t3DropWeights", ConfigDefaults.Factory.T3_SHARD_DROP_WEIGHTS_DEF);
        T4_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 4 factory").define("t4DropWeights", ConfigDefaults.Factory.T4_SHARD_DROP_WEIGHTS_DEF);
        T5_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 5 factory").define("t5DropWeights", ConfigDefaults.Factory.T5_SHARD_DROP_WEIGHTS_DEF);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("headless");
        HEADLESS_1 = COMMON_BUILDER.comment("Percentage chance to drop a skull for headless 1 perks").defineInRange("l1HeadlessChance", 25, 0, 1000);
        HEADLESS_2 = COMMON_BUILDER.comment("Percentage chance to drop a skull for headless 2 perks").defineInRange("l2HeadlessChance", 50, 0, 1000);
        HEADLESS_3 = COMMON_BUILDER.comment("Percentage chance to drop a skull for headless 3 perks").defineInRange("l3HeadlessChance", 80, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("slaughter");
        SLAUGHTER_1 = COMMON_BUILDER.comment("Percentage of liquid meat and pink slime to drop for slaughter 1 perks").defineInRange("l1SlaughterAmount", 100, 0, 1000);
        SLAUGHTER_2 = COMMON_BUILDER.comment("Percentage of liquid meat and pink slime to drop for slaughter 2 perks").defineInRange("l2SlaughterAmount", 120, 0, 1000);
        SLAUGHTER_3 = COMMON_BUILDER.comment("Percentage of liquid meat and pink slime to drop for slaughter 3 perks").defineInRange("l3SlaughterAmount", 140, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("crusher");
        CRUSHER_1 = COMMON_BUILDER.comment("Percentage of essence to drop for crusher 1 perks").defineInRange("l1CrusherAmount", 100, 0, 1000);
        CRUSHER_2 = COMMON_BUILDER.comment("Percentage of essence to drop for crusher 2 perks").defineInRange("l2CrusherAmount", 120, 0, 1000);
        CRUSHER_3 = COMMON_BUILDER.comment("Percentage of essence to drop for crusher 3 perks").defineInRange("l3CrusherAmount", 140, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("laser");
        LASER_1 = COMMON_BUILDER.comment("Percentage of ether gas to drop for laser 1 perks").defineInRange("l1LaserAmount", 100, 0, 1000);
        LASER_2 = COMMON_BUILDER.comment("Percentage of ether gas to drop for laser 2 perks").defineInRange("l2LaserAmount", 120, 0, 1000);
        LASER_3 = COMMON_BUILDER.comment("Percentage of ether gas to drop for laser 3 perks").defineInRange("l3LaserAmount", 140, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("flayed");
        FLAYED_1 = COMMON_BUILDER.comment("Percentage of mob health for flayed 1 perks").defineInRange("l1FlayedAmount", 90, 0, 1000);
        FLAYED_2 = COMMON_BUILDER.comment("Percentage of mob health for flayed 2 perks").defineInRange("l2FlayedAmount", 100, 0, 1000);
        FLAYED_3 = COMMON_BUILDER.comment("Percentage of mob health for flayed 3 perks").defineInRange("l3FlayedAmount", 110, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("xp");
        XP_1 = COMMON_BUILDER.comment("Percentage generate of XP for xp 1 perks").defineInRange("l1Generate", 100, 0, 1000);
        XP_2 = COMMON_BUILDER.comment("Percentage generate of XP for xp 2 perks").defineInRange("l2Generate", 125, 0, 1000);
        XP_3 = COMMON_BUILDER.comment("Percentage generate of XP for xp 3 perks").defineInRange("l3Generate", 150, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
        COMMON_BUILDER.pop();
    }
}

