/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util.helper;

import ipsis.woot.Woot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageHelper {
    public static void insertItems(List<ItemStack> items, List<LazyOptional<IItemHandler>> hdlrs) {
        if (items.isEmpty() || hdlrs.isEmpty()) {
            return;
        }
        for (LazyOptional<IItemHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int i = 0; i < items.size(); ++i) {
                    ItemStack itemStack = (ItemStack)items.get(i);
                    if (itemStack.func_190926_b()) continue;
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)itemStack.func_77946_l(), (boolean)false);
                    items.set(i, remainder);
                }
            });
        }
    }

    public static void insertFluids(List<FluidStack> fluids, List<LazyOptional<IFluidHandler>> hdlrs) {
        if (fluids.isEmpty() || hdlrs.isEmpty()) {
            return;
        }
        for (LazyOptional<IFluidHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                int tanks = h.getTanks();
                if (tanks > 0) {
                    for (int tank = 0; tank < tanks; ++tank) {
                        FluidStack fluidStack = h.getFluidInTank(tank);
                        if (fluidStack == null || fluidStack.isEmpty()) continue;
                        for (FluidStack f : fluids) {
                            if (f.isEmpty() || !fluidStack.isFluidEqual(f)) continue;
                            int filled = h.fill(f, IFluidHandler.FluidAction.EXECUTE);
                            Woot.setup.getLogger().debug("insertFluids: {} ----> topup {} {}", (Object)tank, (Object)f.getTranslationKey(), (Object)filled);
                            if (filled <= 0) continue;
                            f.setAmount(f.getAmount() - filled);
                        }
                    }
                }
            });
        }
        boolean haveFluids = false;
        for (FluidStack fluidStack : fluids) {
            if (fluidStack.isEmpty()) continue;
            haveFluids = true;
        }
        if (haveFluids) {
            for (LazyOptional lazyOptional : hdlrs) {
                lazyOptional.ifPresent(h -> {
                    int tanks = h.getTanks();
                    if (tanks > 0) {
                        for (int tank = 0; tank < tanks; ++tank) {
                            FluidStack fluidStack = h.getFluidInTank(tank);
                            if (!fluidStack.isEmpty()) continue;
                            for (FluidStack f : fluids) {
                                if (f.isEmpty()) continue;
                                int filled = h.fill(f, IFluidHandler.FluidAction.EXECUTE);
                                Woot.setup.getLogger().debug("insertFluids: {} ----> new fill {} {}", (Object)tank, (Object)f.getTranslationKey(), (Object)filled);
                                if (filled <= 0) continue;
                                f.setAmount(f.getAmount() - filled);
                            }
                        }
                    }
                });
            }
        }
    }

    public static List<ItemStack> flattenItemStackList(List<ItemStack> items) {
        ArrayList<ItemStack> flattened = new ArrayList<ItemStack>();
        for (ItemStack itemStack : items) {
            for (ItemStack flatStack : flattened) {
                if (itemStack.func_190926_b()) break;
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)flatStack, (ItemStack)itemStack)) continue;
                flatStack.func_190917_f(itemStack.func_190916_E());
                itemStack.func_190920_e(0);
            }
            if (itemStack.func_190926_b()) continue;
            flattened.add(itemStack.func_77946_l());
        }
        return flattened;
    }

    public static int getCount(ItemStack itemStack, List<LazyOptional<IItemHandler>> hdlrs) {
        AtomicInteger count = new AtomicInteger();
        for (LazyOptional<IItemHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int slot = 0; slot < h.getSlots(); ++slot) {
                    ItemStack slotStack = h.getStackInSlot(slot);
                    if (slotStack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                    count.getAndAdd(slotStack.func_190916_E());
                }
            });
        }
        return count.get();
    }

    public static int getAmount(FluidStack fluidStack, List<LazyOptional<IFluidHandler>> hdlrs) {
        AtomicInteger count = new AtomicInteger();
        for (LazyOptional<IFluidHandler> hdlr : hdlrs) {
            hdlr.ifPresent(h -> {
                for (int slot = 0; slot < h.getTanks(); ++slot) {
                    FluidStack slotStack = h.getFluidInTank(slot);
                    if (slotStack.isEmpty() || !FluidStack.areFluidStackTagsEqual((FluidStack)fluidStack, (FluidStack)slotStack)) continue;
                    count.getAndAdd(slotStack.getAmount());
                }
            });
        }
        return count.get();
    }
}

