/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.tartarus;

import com.mojang.serialization.Codec;
import ipsis.woot.Woot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TartarusChunkGenerator
extends ChunkGenerator {
    public static final Codec<TartarusChunkGenerator> codecTartarusChunk = RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).xmap(TartarusChunkGenerator::new, TartarusChunkGenerator::getBiome).stable().codec();
    private final Registry<Biome> biome;
    public static final int WORK_CHUNK_X = 0;
    public static final int WORK_CHUNK_Z = 0;
    private List<BlockPos> cell0Blocks;
    private List<BlockPos> cell1Blocks;
    private List<BlockPos> cell2Blocks;
    private List<BlockPos> cell3Blocks;

    private TartarusChunkGenerator(Registry<Biome> biome) {
        super((BiomeProvider)new SingleBiomeProvider((Biome)biome.func_243576_d(Biomes.field_76772_c)), new DimensionStructuresSettings(false));
        this.biome = biome;
    }

    public Registry<Biome> getBiome() {
        return this.biome;
    }

    private void calcCellStructures() {
        if (this.cell1Blocks != null) {
            return;
        }
        ArrayList<BlockPos> fullBlocks = new ArrayList<BlockPos>(512);
        for (int x = 0; x < 8; ++x) {
            for (int z = 0; z < 8; ++z) {
                for (int y = 0; y < 8; ++y) {
                    fullBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        ArrayList<BlockPos> innerBlocks = new ArrayList<BlockPos>(512);
        for (int x = 1; x < 7; ++x) {
            for (int z = 1; z < 7; ++z) {
                for (int y = 1; y < 7; ++y) {
                    innerBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        this.cell0Blocks = new ArrayList<BlockPos>();
        for (BlockPos p : fullBlocks) {
            if (innerBlocks.contains(p)) continue;
            this.cell0Blocks.add(new BlockPos((Vector3i)p));
        }
        this.cell1Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell1Blocks.add(new BlockPos(p.func_177958_n() + 8, p.func_177956_o(), p.func_177952_p()));
        }
        this.cell2Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell2Blocks.add(new BlockPos(p.func_177958_n() + 8, p.func_177956_o(), p.func_177952_p() + 8));
        }
        this.cell3Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell3Blocks.add(new BlockPos(p.func_177958_n(), p.func_177956_o(), p.func_177952_p() + 8));
        }
        fullBlocks = null;
        innerBlocks = null;
    }

    private void buildCell(IChunk iChunk, List<BlockPos> posList, int y, BlockState blockState) {
        for (BlockPos pos : posList) {
            iChunk.func_177436_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + y, pos.func_177952_p()), blockState, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long p_230349_1_) {
        return this;
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk) {
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x1 = 0; x1 < 16; ++x1) {
            for (int z1 = 0; z1 < 16; ++z1) {
                for (int y1 = 0; y1 < 256; ++y1) {
                    iChunk.func_177436_a((BlockPos)pos.func_181079_c(x1, y1, z1), blockState, false);
                }
            }
        }
        if (iChunk.func_76632_l().field_77276_a == 0 && iChunk.func_76632_l().field_77275_b == 0) {
            Woot.setup.getLogger().debug("generateSurface: work chunk creating cells");
            BlockState wallState = Blocks.field_150359_w.func_176223_P();
            this.calcCellStructures();
            for (int y = 0; y < 256; y += 8) {
                this.buildCell(iChunk, this.cell0Blocks, y, wallState);
                this.buildCell(iChunk, this.cell1Blocks, y, wallState);
                this.buildCell(iChunk, this.cell2Blocks, y, wallState);
                this.buildCell(iChunk, this.cell3Blocks, y, wallState);
            }
        }
    }

    public void func_230350_a_(long p_230350_1_, BiomeManager p_230350_3_, IChunk p_230350_4_, GenerationStage.Carving p_230350_5_) {
    }

    public void func_230351_a_(WorldGenRegion p_230351_1_, StructureManager p_230351_2_) {
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return codecTartarusChunk;
    }

    public void func_230352_b_(IWorld p_230352_1_, StructureManager p_230352_2_, IChunk p_230352_3_) {
    }

    public int func_222529_a(int i, int i1, Heightmap.Type type) {
        return 0;
    }

    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return new Blockreader(new BlockState[0]);
    }
}

