/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.modules.layout.blocks.LayoutTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class LayoutTileEntitySpecialRenderer
extends TileEntityRenderer<LayoutTileEntity> {
    public LayoutTileEntitySpecialRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(LayoutTileEntity te) {
        return true;
    }

    public void render(LayoutTileEntity layoutTileEntity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = layoutTileEntity.func_145831_w();
        if (world != null) {
            if (layoutTileEntity.getAbsolutePattern() == null) {
                layoutTileEntity.refresh();
            }
            this.textureRender(layoutTileEntity, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    void textureRender(LayoutTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean showAll = tileEntityIn.getLevel() == -1;
        int validY = showAll ? 0 : tileEntityIn.getYForLevel();
        BlockPos origin = tileEntityIn.func_174877_v();
        Direction facing = Direction.SOUTH;
        Block layoutBlock = tileEntityIn.func_145831_w().func_180495_p(origin).func_177230_c();
        if (layoutBlock == LayoutSetup.LAYOUT_BLOCK.get()) {
            facing = (Direction)tileEntityIn.func_145831_w().func_180495_p(origin).func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        for (PatternBlock block : tileEntityIn.getAbsolutePattern().getBlocks()) {
            if (!showAll && block.getBlockPos().func_177956_o() != validY) continue;
            matrixStack.func_227860_a_();
            float x = (float)(origin.func_177958_n() - block.getBlockPos().func_177958_n()) * -1.0f;
            float y = (float)(origin.func_177956_o() - block.getBlockPos().func_177956_o()) * -1.0f;
            float z = (float)(origin.func_177952_p() - block.getBlockPos().func_177952_p()) * -1.0f;
            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
            minX = x < minX ? x : minX;
            minY = y < minY ? y : minY;
            minZ = z < minZ ? z : minZ;
            maxX = x > maxX ? x : maxX;
            maxY = y > maxY ? y : maxY;
            maxZ = z > maxZ ? z : maxZ;
            BlockState blockState = block.getFactoryComponent().getDefaultBlockState();
            if (block.getFactoryComponent() == FactoryComponent.HEART) {
                blockState = (BlockState)((HeartBlock)FactorySetup.HEART_BLOCK.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing);
            }
            Minecraft.func_71410_x().func_175602_ab().renderBlock(blockState, matrixStack, bufferIn, 0xF000F0, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        IVertexBuilder iVertexBuilder = bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_);
        WorldRenderer.func_228428_a_((MatrixStack)matrixStack, (IVertexBuilder)iVertexBuilder, (double)minX, (double)minY, (double)minZ, (double)(maxX += 1.0f), (double)(maxY += 1.0f), (double)(maxZ += 1.0f), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
        matrixStack.func_227865_b_();
    }
}

