/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.blocks;

import ipsis.woot.crafting.InfuserRecipe;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.infuser.blocks.InfuserTileEntity;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class InfuserContainer
extends WootContainer
implements TankPacketHandler {
    public InfuserTileEntity tileEntity;
    private int progress = 0;
    private FluidStack inputFluid = FluidStack.EMPTY;
    private int energy = 0;

    public InfuserContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super((ContainerType)InfuserSetup.INFUSER_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = (InfuserTileEntity)world.func_175625_s(pos);
        this.addOwnSlots();
        this.addPlayerSlots((IInventory)playerInventory);
        this.addListeners();
    }

    private void addOwnSlots() {
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
            this.func_75146_a((Slot)new SlotItemHandler(iItemHandler, 0, 46, 40));
            this.func_75146_a((Slot)new SlotItemHandler(iItemHandler, 1, 64, 40));
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 2, 118, 40){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return false;
                }
            });
        });
    }

    private void addPlayerSlots(IInventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 10 + col * 18;
                int y = row * 18 + 95;
                this.func_75146_a(new Slot(playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 10 + row * 18;
            this.func_75146_a(new Slot(playerInventory, row, x, 153));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergy() {
        return this.energy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.inputFluid.isFluidStackIdentical(this.tileEntity.getTankFluid())) {
            this.inputFluid = this.tileEntity.getTankFluid().copy();
            TankPacket tankPacket = new TankPacket(0, this.inputFluid);
            for (IContainerListener l : this.field_75149_d) {
                if (!(l instanceof ServerPlayerEntity)) continue;
                NetworkChannel.channel.sendTo((Object)tankPacket, ((ServerPlayerEntity)l).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return InfuserContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)InfuserSetup.INFUSER_BLOCK.get()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        int MACHINE_INV_SIZE = 3;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 3) {
            if (InfuserRecipe.isValidInput(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (InfuserRecipe.isValidAugment(stack)) {
                startIndex = 1;
                endIndex = 2;
            } else if (index < 30) {
                startIndex = 30;
                endIndex = startIndex + 9;
            } else {
                if (index < 30) return ItemStack.field_190927_a;
                startIndex = 3;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 3;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.func_75135_a(stack, startIndex, endIndex, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stack.func_190916_E() == stackCopy.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(playerIn, stack);
        return stackCopy;
    }

    public void addListeners() {
        this.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tileEntity.getEnergy();
            }

            public void func_221494_a(int i) {
                InfuserContainer.this.energy = i;
            }
        });
        this.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tileEntity.getProgress();
            }

            public void func_221494_a(int i) {
                InfuserContainer.this.progress = i;
            }
        });
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId == 0) {
            this.inputFluid = packet.fluidStack;
        }
    }
}

