/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.PatternBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatternRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    static PatternRepository INSTANCE = new PatternRepository();
    int maxYOffset = 0;
    int maxXZOffset = 0;
    EnumMap<Tier, Pattern> patterns = new EnumMap(Tier.class);
    EnumMap<Tier, String[][]> rawPatterns = new EnumMap(Tier.class);
    private final Character WILDSTAR_CHAR = Character.valueOf('-');
    private final Character HEART_CHAR = Character.valueOf('H');
    private final HashMap<Character, FactoryComponent> CHAR_MAPPINGS = new HashMap();
    private final String[][] LAYOUT1;
    private final String[][] LAYOUT;

    public PatternRepository() {
        this.CHAR_MAPPINGS.put(Character.valueOf('a'), FactoryComponent.FACTORY_A);
        this.CHAR_MAPPINGS.put(Character.valueOf('b'), FactoryComponent.FACTORY_B);
        this.CHAR_MAPPINGS.put(Character.valueOf('c'), FactoryComponent.FACTORY_C);
        this.CHAR_MAPPINGS.put(Character.valueOf('d'), FactoryComponent.FACTORY_D);
        this.CHAR_MAPPINGS.put(Character.valueOf('e'), FactoryComponent.FACTORY_E);
        this.CHAR_MAPPINGS.put(Character.valueOf('z'), FactoryComponent.FACTORY_CONNECT);
        this.CHAR_MAPPINGS.put(Character.valueOf('Y'), FactoryComponent.FACTORY_CTR_BASE_PRI);
        this.CHAR_MAPPINGS.put(Character.valueOf('y'), FactoryComponent.FACTORY_CTR_BASE_SEC);
        this.CHAR_MAPPINGS.put(Character.valueOf('U'), FactoryComponent.FACTORY_UPGRADE);
        this.CHAR_MAPPINGS.put(Character.valueOf('I'), FactoryComponent.IMPORT);
        this.CHAR_MAPPINGS.put(Character.valueOf('E'), FactoryComponent.EXPORT);
        this.CHAR_MAPPINGS.put(Character.valueOf('1'), FactoryComponent.CAP_A);
        this.CHAR_MAPPINGS.put(Character.valueOf('2'), FactoryComponent.CAP_B);
        this.CHAR_MAPPINGS.put(Character.valueOf('3'), FactoryComponent.CAP_C);
        this.CHAR_MAPPINGS.put(Character.valueOf('4'), FactoryComponent.CAP_D);
        this.CHAR_MAPPINGS.put(this.HEART_CHAR, FactoryComponent.HEART);
        this.CHAR_MAPPINGS.put(Character.valueOf('C'), FactoryComponent.CONTROLLER);
        this.CHAR_MAPPINGS.put(Character.valueOf('P'), FactoryComponent.CELL);
        this.LAYOUT1 = new String[][]{{"-------", "-------", "---P---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---E---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---I---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---z---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---z---", "-------", "-------", "-------", "-------"}, {"-------", "---Y---", "---a---", "-------", "-------", "-------", "-------"}, {"-------", "---C---", "---a---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---U---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---H---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "-------", "-------", "-------", "-------", "-------"}};
        this.LAYOUT = new String[][]{{"-------", "-------", "---P---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---E---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---I---", "-------", "-------", "-------", "-------"}, {"-------", "-------", "---z---", "-------", "-------", "-------", "-------"}, {"-------", "---z---", "---z---", "-zzzzz-", "---z---", "---z---", "-------"}, {"-e---e-", "edcYcde", "-caaac-", "-yazay-", "-caaac-", "edcycde", "-e---e-"}, {"-4---4-", "4dcCcd4", "-cbabc-", "-CbbbC-", "-cbbbc-", "4dcCcd4", "-4---4-"}, {"-------", "-3c-c3-", "-cbUbc-", "--UaU--", "-cbUbc-", "-3c-c3-", "-------"}, {"-------", "--2-2--", "-2bHb2-", "---b---", "-2b-b2-", "--2-2--", "-------"}, {"-------", "-------", "--1-1--", "-------", "--1-1--", "-------", "-------"}};
    }

    public static PatternRepository get() {
        return INSTANCE;
    }

    public void load() {
        this.createRawPatterns();
        this.createPattern(Tier.TIER_1);
        this.createPattern(Tier.TIER_2);
        this.createPattern(Tier.TIER_3);
        this.createPattern(Tier.TIER_4);
        this.createPattern(Tier.TIER_5);
    }

    void createPattern(Tier tier) {
        int col;
        int row;
        int layer;
        String[][] rawPattern = this.rawPatterns.get((Object)tier);
        int height = rawPattern.length;
        if (rawPattern.length == 0) {
            LOGGER.error("Pattern for tier {} has height of 0", (Object)tier);
            return;
        }
        int rows = rawPattern[0].length;
        if (rows == 0) {
            LOGGER.error("Pattern for tier {} has row count of 0", (Object)tier);
            return;
        }
        int cols = rawPattern[0][0].length();
        if (cols == 0) {
            LOGGER.error("Pattern for tier {} has col count of 0", (Object)tier);
            return;
        }
        Pattern pattern = new Pattern(rows, height);
        for (int layer2 = 0; layer2 < height; ++layer2) {
            for (int row2 = 0; row2 < rows; ++row2) {
                for (int col2 = 0; col2 < cols; ++col2) {
                    if (rawPattern[layer2][row2].length() == cols) continue;
                    LOGGER.error("Pattern for tier {} row {} is too short", (Object)tier, (Object)row2);
                    return;
                }
            }
        }
        boolean hasOrigin = false;
        block3: for (layer = 0; layer < height; ++layer) {
            for (row = 0; row < rows; ++row) {
                for (col = 0; col < cols; ++col) {
                    if (rawPattern[layer][row].charAt(col) != this.HEART_CHAR.charValue()) continue;
                    pattern.setOrigin(layer, row, col);
                    hasOrigin = true;
                    break block3;
                }
            }
        }
        if (!hasOrigin) {
            LOGGER.error("Pattern for tier {} has no origin", (Object)tier);
            return;
        }
        for (layer = 0; layer < height; ++layer) {
            for (row = 0; row < rows; ++row) {
                for (col = 0; col < cols; ++col) {
                    if (rawPattern[layer][row].length() == cols) continue;
                    LOGGER.error("Pattern for tier {} row {} is too short", (Object)tier, (Object)row);
                    return;
                }
                for (col = 0; col < cols; ++col) {
                    char c = rawPattern[layer][row].charAt(col);
                    if (c == this.WILDSTAR_CHAR.charValue()) continue;
                    FactoryComponent component = this.CHAR_MAPPINGS.getOrDefault(Character.valueOf(c), null);
                    if (component == null) {
                        LOGGER.error("Pattern for tier {} invalid char {} @ {},{},{}", (Object)Character.valueOf(c), (Object)layer, (Object)row, (Object)col);
                        continue;
                    }
                    pattern.addComponent(component, layer, row, col);
                }
            }
        }
        this.patterns.put(tier, pattern);
        if (this.maxYOffset == 0 || this.maxYOffset < height) {
            this.maxYOffset = height;
        }
        if (this.maxXZOffset == 0 || this.maxXZOffset < rows) {
            this.maxXZOffset = rows;
        }
    }

    public int getMaxYOffset() {
        return this.maxYOffset;
    }

    public int getMaxXZOffset() {
        return this.maxXZOffset;
    }

    public Pattern getPattern(Tier tier) {
        return this.patterns.get((Object)tier);
    }

    void createRawPatterns() {
        String TIER_2_PATTERN = "[cde234]";
        String TIER_3_PATTERN = "[de34]";
        String TIER_4_PATTERN = "[e4]";
        String TIER_5_PATTERN = "";
        this.addTier(Tier.TIER_1, "", this.LAYOUT1);
        this.addTier(Tier.TIER_2, "[cde234]", this.LAYOUT);
        this.addTier(Tier.TIER_3, "[de34]", this.LAYOUT);
        this.addTier(Tier.TIER_4, "[e4]", this.LAYOUT);
        this.addTier(Tier.TIER_5, "", this.LAYOUT);
    }

    void addTier(Tier tier, String pattern, String[][] layout) {
        String[][] tmp = new String[layout.length][layout[0].length];
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[i].length; ++j) {
                tmp[i][j] = !pattern.isEmpty() ? layout[i][j].replaceAll(pattern, this.WILDSTAR_CHAR.toString()) : layout[i][j];
            }
        }
        this.rawPatterns.put(tier, tmp);
    }

    public class Pattern {
        int height;
        int width;
        int originLayer;
        int originRow;
        int originCol;
        HashMap<FactoryComponent, Integer> componentCounts = new HashMap();
        private List<PatternBlock> blocks = new ArrayList<PatternBlock>();

        public Pattern(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setOrigin(int layer, int row, int col) {
            this.originLayer = layer;
            this.originRow = row;
            this.originCol = col;
        }

        public void addComponent(FactoryComponent component, int layer, int row, int col) {
            int x = (this.originCol - col) * -1;
            int y = (this.originLayer - layer) * -1;
            int z = (this.originRow - row) * -1;
            this.blocks.add(new PatternBlock(component, new BlockPos(x, y, z)));
            this.componentCounts.put(component, this.componentCounts.getOrDefault((Object)component, 0) + 1);
        }

        public List<PatternBlock> getPatternBlocks() {
            return Collections.unmodifiableList(this.blocks);
        }

        public int getFactoryBlockCount(FactoryComponent component) {
            return this.componentCounts.getOrDefault((Object)component, 0);
        }
    }
}

