/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.debug.blocks;

import ipsis.woot.modules.debug.DebugSetup;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootFluidTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class DebugTankTileEntity
extends TileEntity
implements WootDebug {
    private LazyOptional<WootFluidTank> inputTank = LazyOptional.of(this::createTank);

    public DebugTankTileEntity() {
        super((TileEntityType)DebugSetup.DEBUG_TANK_BLOCK_TILE.get());
    }

    private WootFluidTank createTank() {
        return new WootFluidTank(Integer.MAX_VALUE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.inputTank.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> DebugTankTileEntity");
        this.inputTank.ifPresent(h -> {
            if (h.getFluid().isEmpty()) {
                debug.add("    Empty");
            } else {
                debug.add("    " + h.getFluid().getTranslationKey() + "/" + h.getFluidAmount());
            }
        });
        return debug;
    }
}

