/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.crafting.FactoryRecipe;
import ipsis.woot.util.FakeMob;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class FactoryRecipeBuilder {
    private final FakeMob result;
    private final NonNullList<ItemStack> items;
    private final NonNullList<FluidStack> fluids;
    private final NonNullList<FactoryRecipe.Drop> drops;
    @ObjectHolder(value="woot:factory")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public FactoryRecipeBuilder(FakeMob result) {
        this.result = result;
        this.items = NonNullList.func_191196_a();
        this.fluids = NonNullList.func_191196_a();
        this.drops = NonNullList.func_191196_a();
    }

    public static FactoryRecipeBuilder factoryRecipe(FakeMob result) {
        return new FactoryRecipeBuilder(result);
    }

    public FactoryRecipeBuilder addIngredient(ItemStack itemStack) {
        this.items.add((Object)itemStack);
        return this;
    }

    public FactoryRecipeBuilder addIngredient(FluidStack fluidStack) {
        this.fluids.add((Object)fluidStack);
        return this;
    }

    public FactoryRecipeBuilder addDrop(FactoryRecipe.Drop drop) {
        this.drops.add((Object)drop);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> recipe, String name) {
        recipe.accept(new Result(new ResourceLocation("woot", "factory/" + name), this.result, this.items, this.fluids, this.drops));
    }

    public static class Result
    implements IFinishedRecipe {
        private final FakeMob result;
        private final NonNullList<ItemStack> items;
        private final NonNullList<FluidStack> fluids;
        private final NonNullList<FactoryRecipe.Drop> drops;
        private final ResourceLocation id;

        public Result(ResourceLocation id, FakeMob result, NonNullList<ItemStack> items, NonNullList<FluidStack> fluids, NonNullList<FactoryRecipe.Drop> drops) {
            this.id = id;
            this.result = result;
            this.items = items;
            this.fluids = fluids;
            this.drops = drops;
        }

        public void func_218610_a(JsonObject json) {
            JsonObject jsonObject;
            json.addProperty("mob", this.result.getResourceLocation().toString());
            JsonArray array = new JsonArray();
            for (ItemStack itemStack : this.items) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemStack.func_77973_b()).toString());
                jsonObject.addProperty("count", (Number)itemStack.func_190916_E());
                array.add((JsonElement)jsonObject);
            }
            json.add("items", (JsonElement)array);
            array = new JsonArray();
            for (FluidStack fluidStack : this.fluids) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluidStack.getFluid()).toString());
                jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
                array.add((JsonElement)jsonObject);
            }
            json.add("fluids", (JsonElement)array);
            array = new JsonArray();
            for (FactoryRecipe.Drop d : this.drops) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)d.itemStack.func_77973_b()).toString());
                JsonArray sizes = new JsonArray();
                for (int i = 0; i < d.stackSizes.length; ++i) {
                    sizes.add((Number)d.stackSizes[i]);
                }
                jsonObject.add("sizes", (JsonElement)sizes);
                JsonArray chances = new JsonArray();
                for (int i = 0; i < d.dropChance.length; ++i) {
                    chances.add((Number)Float.valueOf(d.dropChance[i]));
                }
                jsonObject.add("chances", (JsonElement)chances);
                array.add((JsonElement)jsonObject);
            }
            json.add("drops", (JsonElement)array);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

