/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import ipsis.woot.Woot;
import ipsis.woot.crafting.AnvilRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AnvilRecipeSerializer<T extends AnvilRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public AnvilRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            Ingredient baseIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            NonNullList ingredients = NonNullList.func_191196_a();
            int ingCount = buffer.readShort();
            if (ingCount != 0) {
                for (int i = 0; i < ingCount; ++i) {
                    ingredients.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
                }
            }
            ItemStack result = buffer.func_150791_c();
            return this.factory.create(recipeId, baseIngredient, (IItemProvider)result.func_77973_b(), result.func_190916_E(), (NonNullList<Ingredient>)ingredients);
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("AnvilRecipeSerializer:read", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            ((AnvilRecipe)recipe).getBaseIngredient().func_199564_a(buffer);
            buffer.writeShort(((AnvilRecipe)recipe).func_192400_c().size());
            for (Ingredient ingredient : ((AnvilRecipe)recipe).func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(((AnvilRecipe)recipe).getOutput());
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("AnvilRecipeSerializer:write", (Throwable)e);
            throw e;
        }
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"base") ? JSONUtils.func_151214_t((JsonObject)json, (String)"base") : JSONUtils.func_152754_s((JsonObject)json, (String)"base");
        Ingredient baseIngredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        NonNullList<Ingredient> nonnulllist = AnvilRecipeSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for anvil recipe");
        }
        if (nonnulllist.size() > 4) {
            throw new JsonParseException("Too many ingredients for anvil recipe the max is 4");
        }
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        return this.factory.create(recipeId, baseIngredient, (IItemProvider)result.func_77973_b(), result.func_190916_E(), nonnulllist);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static interface IFactory<T extends AnvilRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, IItemProvider var3, int var4, NonNullList<Ingredient> var5);
    }
}

