/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import ipsis.woot.crafting.AnvilRecipeBuilder;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.items.MobShardItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AnvilRecipe
implements IRecipe<IInventory> {
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient baseIngredient;
    private final Item result;
    private final int count;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    public static final IRecipeType<AnvilRecipe> ANVIL_TYPE = IRecipeType.func_222147_a((String)"woot:anvil");
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();

    public AnvilRecipe(ResourceLocation id, Ingredient baseIngredient, IItemProvider result, int count, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.baseIngredient = baseIngredient;
        this.result = result.func_199767_j();
        this.count = count;
        this.ingredients = ingredients;
        this.type = ANVIL_TYPE;
        if (baseIngredient.func_193365_a().length == 1 && baseIngredient.func_193365_a()[0].func_77973_b() == FactorySetup.MOB_SHARD_ITEM.get()) {
            ItemStack itemStack = new ItemStack((IItemProvider)FactorySetup.MOB_SHARD_ITEM.get());
            MobShardItem.setJEIEnderShard(itemStack);
            this.inputs.add(Arrays.asList(itemStack));
        } else {
            this.inputs.add(Arrays.asList(baseIngredient.func_193365_a()));
        }
        for (Ingredient i : ingredients) {
            this.inputs.add(Arrays.asList(i.func_193365_a()));
        }
    }

    public Ingredient getBaseIngredient() {
        return this.baseIngredient;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack getOutput() {
        return new ItemStack((IItemProvider)this.result, this.count);
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (!this.baseIngredient.test(inv.func_70301_a(0))) {
            return false;
        }
        int count = 0;
        for (int i = 1; i < 4; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++count;
        }
        if (this.ingredients.size() != count) {
            return false;
        }
        ArrayList<Integer> matchedSlots = new ArrayList<Integer>();
        block1: for (Ingredient ingredient : this.ingredients) {
            for (int i = 1; i < 4; ++i) {
                if (matchedSlots.contains(i) || !ingredient.test(inv.func_70301_a(i))) continue;
                matchedSlots.add(i);
                continue block1;
            }
        }
        return matchedSlots.size() == this.ingredients.size();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return AnvilRecipeBuilder.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }
}

