/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wirelesschargers.WirelessChargers;
import com.supermartijn642.wirelesschargers.packets.ToggleHighlightAreaPacket;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class HighlightAreaButton
extends AbstractButtonWidget
implements IHoverTextWidget {
    private static final ResourceLocation BUTTONS = new ResourceLocation("wirelesschargers", "textures/screen/highlight_area_buttons.png");
    private final Supplier<Boolean> highlightArea;

    public HighlightAreaButton(int x, int y, BlockPos tilePos, Supplier<Boolean> highlightArea) {
        super(x, y - 3, 24, 24, () -> WirelessChargers.CHANNEL.sendToServer((BasePacket)new ToggleHighlightAreaPacket(tilePos)));
        this.highlightArea = highlightArea;
    }

    protected ITextComponent getNarrationMessage() {
        return this.getHoverText();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)BUTTONS);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.highlightArea.get() != false ? 0.0f : 0.5f), (float)((float)(this.active ? (this.hovered ? 1 : 0) : 2) / 3.0f), (float)0.5f, (float)0.33333334f);
    }

    public ITextComponent getHoverText() {
        IFormattableTextComponent value = this.highlightArea.get() != false ? TextComponents.string((String)"True").color(TextFormatting.GREEN).get() : TextComponents.string((String)"False").color(TextFormatting.RED).get();
        return TextComponents.translation((String)"wirelesschargers.screen.highlight_area", (Object[])new Object[]{value}).color(TextFormatting.GRAY).get();
    }
}

