/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class EnergyBarWidget
extends AbstractButtonWidget
implements IHoverTextWidget {
    private static final ResourceLocation BARS = new ResourceLocation("wirelesschargers", "textures/screen/energy_bars.png");
    private final Supplier<Integer> energy;
    private final Supplier<Integer> capacity;

    public EnergyBarWidget(int x, int y, int width, int height, Supplier<Integer> energy, Supplier<Integer> capacity) {
        super(x, y, width, height, () -> EnergyFormat.cycleEnergyType((!Screen.func_231173_s_() ? 1 : 0) != 0));
        this.energy = energy;
        this.capacity = capacity;
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float percentage;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BARS);
        GlStateManager.func_227709_e_();
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.isHovered() ? 0.09090909f : 0.0f), (float)0.0f, (float)0.09090909f, (float)1.0f);
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        float f = percentage = capacity == 0 ? 1.0f : Math.max(Math.min((float)energy / (float)capacity, 1.0f), 0.0f);
        if (percentage != 0.0f) {
            ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)((float)this.y + (float)this.height * (1.0f - percentage)), (float)this.width, (float)((float)this.height * percentage), (float)0.27272728f, (float)(1.0f - percentage), (float)0.09090909f, (float)percentage);
        }
    }

    public ITextComponent getHoverText() {
        IFormattableTextComponent energy = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.energy.get())).color(TextFormatting.GOLD).get();
        IFormattableTextComponent capacity = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.capacity.get())).color(TextFormatting.GOLD).string(" " + EnergyFormat.formatUnit()).color(TextFormatting.GRAY).get();
        return TextComponents.translation((String)"wirelesschargers.screen.stored_energy", (Object[])new Object[]{energy, capacity}).color(TextFormatting.GRAY).get();
    }

    protected ITextComponent getNarrationMessage() {
        return this.getHoverText();
    }
}

