/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wirelesschargers.ChargerType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChargerAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ChargerAdvancementProvider(GatherDataEvent e) {
        this.generator = e.getGenerator();
    }

    public void func_200398_a(DirectoryCache hashCache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path advancementPath = ChargerAdvancementProvider.createPath(path, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)hashCache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        Advancement wireless_charging = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)ChargerType.BASIC_WIRELESS_PLAYER_CHARGER.getItem(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.wireless_charging.title").get(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.wireless_charging.description").get(), new ResourceLocation("minecraft", "textures/block/redstone_block.png"), FrameType.TASK, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_200275_a("has_player_charger", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ChargerType.BASIC_WIRELESS_PLAYER_CHARGER.getItem()})).func_200275_a("has_block_charger", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ChargerType.BASIC_WIRELESS_BLOCK_CHARGER.getItem()})).func_203904_a(consumer, "wirelesschargers:wireless_charging");
        Advancement no_more_batteries = Advancement.Builder.func_200278_a().func_203905_a(wireless_charging).func_203902_a((IItemProvider)ChargerType.ADVANCED_WIRELESS_PLAYER_CHARGER.getItem(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.no_more_batteries.title").get(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.no_more_batteries.description").get(), null, FrameType.TASK, true, true, false).func_200275_a("has_charger", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ChargerType.ADVANCED_WIRELESS_PLAYER_CHARGER.getItem()})).func_203904_a(consumer, "wirelesschargers:no_more_batteries");
        Advancement no_more_cables = Advancement.Builder.func_200278_a().func_203905_a(wireless_charging).func_203902_a((IItemProvider)ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER.getItem(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.no_more_cables.title").get(), (ITextComponent)TextComponents.translation((String)"wirelesschargers.advancement.no_more_cables.description").get(), null, FrameType.TASK, true, true, false).func_200275_a("has_charger", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER.getItem()})).func_203904_a(consumer, "wirelesschargers:no_more_cables");
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Advancements";
    }
}

