/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import com.supermartijn642.wirelesschargers.data.ChargerAdvancementProvider;
import com.supermartijn642.wirelesschargers.data.ChargerBlockStateProvider;
import com.supermartijn642.wirelesschargers.data.ChargerItemModelProvider;
import com.supermartijn642.wirelesschargers.data.ChargerLanguageProvider;
import com.supermartijn642.wirelesschargers.data.ChargerLootTableProvider;
import com.supermartijn642.wirelesschargers.data.ChargerRecipeProvider;
import com.supermartijn642.wirelesschargers.packets.CycleRedstoneModePacket;
import com.supermartijn642.wirelesschargers.packets.ToggleHighlightAreaPacket;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="wirelesschargers")
public class WirelessChargers {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"wirelesschargers");
    public static final ItemGroup GROUP = new ItemGroup("wirelesschargers"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER.getItem());
        }
    };

    public WirelessChargers() {
        CHANNEL.registerMessage(ToggleHighlightAreaPacket.class, ToggleHighlightAreaPacket::new, true);
        CHANNEL.registerMessage(CycleRedstoneModePacket.class, CycleRedstoneModePacket::new, true);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModCompatibility::init);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            for (ChargerType type : ChargerType.values()) {
                type.registerBlock((IForgeRegistry<Block>)e.getRegistry());
            }
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> e) {
            for (ChargerType type : ChargerType.values()) {
                type.registerTileEntity(e.getRegistry());
            }
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            for (ChargerType type : ChargerType.values()) {
                type.registerItem((IForgeRegistry<Item>)e.getRegistry());
            }
        }

        @SubscribeEvent
        public static void onGatherData(GatherDataEvent e) {
            e.getGenerator().func_200390_a((IDataProvider)new ChargerItemModelProvider(e));
            e.getGenerator().func_200390_a((IDataProvider)new ChargerBlockStateProvider(e));
            e.getGenerator().func_200390_a((IDataProvider)new ChargerLanguageProvider(e));
            e.getGenerator().func_200390_a((IDataProvider)new ChargerLootTableProvider(e));
            e.getGenerator().func_200390_a((IDataProvider)new ChargerRecipeProvider(e));
            e.getGenerator().func_200390_a((IDataProvider)new ChargerAdvancementProvider(e));
        }
    }
}

