/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.wirelesschargers.ChargerBlock;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerItemStackBlockEntityRenderer;
import com.supermartijn642.wirelesschargers.ChargerModelType;
import com.supermartijn642.wirelesschargers.WirelessChargers;
import com.supermartijn642.wirelesschargers.WirelessChargersConfig;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ChargerType {
    BASIC_WIRELESS_BLOCK_CHARGER(true, false, WirelessChargersConfig.basicBlockChargerRange, WirelessChargersConfig.basicBlockChargerCapacity, WirelessChargersConfig.basicBlockChargerTransferRate, ChargerModelType.BASIC_WIRELESS_BLOCK_CHARGER, "Basic Wireless Block Charger"),
    ADVANCED_WIRELESS_BLOCK_CHARGER(true, false, WirelessChargersConfig.advancedBlockChargerRange, WirelessChargersConfig.advancedBlockChargerCapacity, WirelessChargersConfig.advancedBlockChargerTransferRate, ChargerModelType.ADVANCED_WIRELESS_BLOCK_CHARGER, "Advanced Wireless Block Charger"),
    BASIC_WIRELESS_PLAYER_CHARGER(false, true, WirelessChargersConfig.basicPlayerChargerRange, WirelessChargersConfig.basicPlayerChargerCapacity, WirelessChargersConfig.basicPlayerChargerTransferRate, ChargerModelType.BASIC_WIRELESS_PLAYER_CHARGER, "Basic Wireless Player Charger"),
    ADVANCED_WIRELESS_PLAYER_CHARGER(false, true, WirelessChargersConfig.advancedPlayerChargerRange, WirelessChargersConfig.advancedPlayerChargerCapacity, WirelessChargersConfig.advancedPlayerChargerTransferRate, ChargerModelType.ADVANCED_WIRELESS_PLAYER_CHARGER, "Advanced Wireless Player Charger");

    private TileEntityType<ChargerBlockEntity> tileEntityType;
    private ChargerBlock block;
    private BlockItem item;
    public final boolean canChargeBlocks;
    public final boolean canChargePlayers;
    public final Supplier<Integer> range;
    public final Supplier<Integer> capacity;
    public final Supplier<Integer> transferRate;
    public final ChargerModelType modelType;
    public final String englishTranslation;

    private ChargerType(boolean canChargeBlocks, boolean canChargePlayers, Supplier<Integer> range, Supplier<Integer> capacity, Supplier<Integer> transferRate, ChargerModelType modelType, String englishTranslation) {
        this.canChargeBlocks = canChargeBlocks;
        this.canChargePlayers = canChargePlayers;
        this.range = range;
        this.capacity = capacity;
        this.transferRate = transferRate;
        this.modelType = modelType;
        this.englishTranslation = englishTranslation;
    }

    public String getRegistryName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ChargerBlock getBlock() {
        return this.block;
    }

    public ChargerBlockEntity createTileEntity() {
        return new ChargerBlockEntity(this);
    }

    public TileEntityType<ChargerBlockEntity> getTileEntityType() {
        return this.tileEntityType;
    }

    public BlockItem getItem() {
        return this.item;
    }

    public void registerBlock(IForgeRegistry<Block> registry) {
        if (this.block != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.block = new ChargerBlock(this);
        registry.register((IForgeRegistryEntry)this.block);
    }

    public void registerTileEntity(IForgeRegistry<TileEntityType<?>> registry) {
        if (this.tileEntityType != null) {
            throw new IllegalStateException("Tile entities have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering tile entity types!");
        }
        this.tileEntityType = TileEntityType.Builder.func_223042_a(this::createTileEntity, (Block[])new Block[]{this.block}).func_206865_a(null);
        this.tileEntityType.setRegistryName(this.getRegistryName() + "_block_entity");
        registry.register(this.tileEntityType);
    }

    public void registerItem(IForgeRegistry<Item> registry) {
        if (this.item != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.item = new BlockItem((Block)this.block, new Item.Properties().func_200916_a(WirelessChargers.GROUP).setISTER(() -> ChargerItemStackBlockEntityRenderer::getInstance));
        this.item.setRegistryName(this.block.getRegistryName());
        registry.register((IForgeRegistryEntry)this.item);
    }
}

