/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.gardentrowel;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.gardentrowel.GardenTrowelRecipe;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class GardenTrowelCategory
implements IRecipeCategory<GardenTrowelRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_garden_trowel.png");

    public GardenTrowelCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 170, 56);
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemRegistry.garden_trowel));
    }

    public ResourceLocation getUid() {
        return WaterStrainerPlugin.UID_CAT_GARDEN_TROWEL;
    }

    public Class<? extends GardenTrowelRecipe> getRecipeClass() {
        return GardenTrowelRecipe.class;
    }

    public String getTitle() {
        return "Worm Drops";
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void draw(GardenTrowelRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        ItemStack input = recipe.getInput().get(1).get(0);
        int chance = Block.func_149634_a((Item)input.func_77973_b()) == Blocks.field_150458_ak ? 50 : 25;
        String chanceStr = chance + "% Chance";
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_238421_b_(matrix, chanceStr, (float)(87 - minecraft.field_71466_p.func_78256_a(chanceStr) / 2), 5.0f, -8355712);
    }

    public void setIngredients(GardenTrowelRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInput());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GardenTrowelRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 36, 19);
        guiItemStacks.init(1, true, 56, 19);
        guiItemStacks.init(2, false, 116, 19);
        guiItemStacks.set(ingredients);
    }
}

