/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiStrainer
extends ContainerScreen<ContainerStrainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/strainer_base.png");
    private final TileEntityStrainer tile;
    private final PlayerInventory playerInventory;
    private EnumStatus status = EnumStatus.GREEN;
    private List<String> statusText = new ArrayList<String>();
    private List<ITextComponent> statusTextComponent = new ArrayList<ITextComponent>();
    private long updateTime = System.currentTimeMillis();

    public GuiStrainer(ContainerStrainer container, PlayerInventory playerInventory, ITextComponent text) {
        super((Container)container, playerInventory, text);
        this.playerInventory = playerInventory;
        this.tile = container.strainer;
        this.field_147000_g = 226;
        this.refreshStatus();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        Slot slot;
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        if (Math.abs(System.currentTimeMillis() - this.updateTime) > 250L) {
            this.updateTime = System.currentTimeMillis();
            this.refreshStatus();
        }
        if ((slot = this.getSlotUnderMouse()) != null) {
            int slotIndex = slot.field_75222_d;
            if (slot.func_75216_d()) {
                return;
            }
            if (slotIndex == 0) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Strainer Slot"), mouseX, mouseY);
            } else if (slotIndex == 28) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Bait Slot"), mouseX, mouseY);
            } else if (slotIndex == 29) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Bait Pot Slot"), mouseX, mouseY);
            }
        }
        if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 98, this.field_147009_r + 21, 3, 16)) {
            int progress = this.status != EnumStatus.RED ? this.getProgressPercentage() : 0;
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(progress + "%"), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 155, this.field_147009_r + 22, 16, 16)) {
            this.func_243308_b(matrix, this.statusTextComponent, mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 155, this.field_147009_r + 5, 16, 16) && !APIUtils.isJEILoaded()) {
            this.func_243308_b(matrix, Arrays.asList(new StringTextComponent("Show Recipes"), new StringTextComponent("This function is only available if you"), new StringTextComponent(WaterStrainerUtils.ctext("have #BLUE#Just Enough Items (JEI)#RESET# installed."))), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(matrix, s, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.playerInventory.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(guiTexture);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        this.func_238474_b_(matrix, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.inv.getStackInSlot(0).func_190926_b()) {
            this.func_238474_b_(matrix, k + 80, l + 21, 176, 0, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(28).func_190926_b()) {
            this.func_238474_b_(matrix, k + 70, l + 41, 176, 32, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(29).func_190926_b()) {
            this.func_238474_b_(matrix, k + 90, l + 41, 176, 16, 16, 16);
        }
        if (this.status == EnumStatus.RED) {
            this.func_238474_b_(matrix, k + 155, l + 22, 176, 48, 16, 16);
        } else if (this.status == EnumStatus.YELLOW) {
            this.func_238474_b_(matrix, k + 155, l + 22, 176, 64, 16, 16);
        } else {
            this.func_238474_b_(matrix, k + 155, l + 22, 176, 80, 16, 16);
        }
        int length = this.status != EnumStatus.RED ? this.getProgressBarLength() : 0;
        this.func_238474_b_(matrix, k + 99, l + 35 - length, 192, 13 - length, 1, length + 1);
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    private void refreshStatus() {
        this.statusText.clear();
        this.statusTextComponent.clear();
        if (!(this.tile.getStrainer().func_77973_b() instanceof ItemStrainer)) {
            this.statusText.add("- Strainer missing");
        }
        if (!BlockStrainerBase.isStrainerInLiquid(this.tile.func_145831_w(), this.tile.func_174877_v())) {
            this.statusText.add("- Water missing");
        }
        if (this.getBaitStatus() == EnumBaitStatus.REQUIRED) {
            this.statusText.add("- Bait missing");
        }
        if (this.statusText.isEmpty()) {
            if (this.getBaitStatus() == EnumBaitStatus.REDUNDANT) {
                this.status = EnumStatus.YELLOW;
                this.statusText.add(0, TextFormatting.YELLOW + "Status");
                this.statusText.add("- Bait redundant");
            } else {
                this.status = EnumStatus.GREEN;
                this.statusText.add(0, TextFormatting.GREEN + "Status");
                this.statusText.add("No problems detected");
            }
        } else {
            this.status = EnumStatus.RED;
            this.statusText.add(0, TextFormatting.RED + "Status");
        }
        for (String s : this.statusText) {
            this.statusTextComponent.add((ITextComponent)new StringTextComponent(s));
        }
    }

    private EnumBaitStatus getBaitStatus() {
        ItemStack stack = this.tile.inv.getStackInSlot(0);
        ItemStack bait = this.tile.inv.getStackInSlot(28);
        if (stack.func_77973_b() instanceof ItemStrainer) {
            ItemStrainer strainer = (ItemStrainer)stack.func_77973_b();
            if (strainer.TYPE.category != ItemStrainer.StrainerCategory.FISHER) {
                if (!bait.func_190926_b()) {
                    return EnumBaitStatus.REDUNDANT;
                }
            } else if (bait.func_190926_b()) {
                return EnumBaitStatus.REQUIRED;
            }
        }
        return EnumBaitStatus.NONE;
    }

    private int getProgressPercentage() {
        int curIdle = ((ContainerStrainer)this.field_147002_h).getCurIdle();
        int maxIdle = ((ContainerStrainer)this.field_147002_h).getMaxIdle();
        return curIdle > 0 && maxIdle > 0 ? (int)(100.0f / (float)maxIdle * (float)curIdle) : 0;
    }

    private int getProgressBarLength() {
        return (int)(0.14f * (float)this.getProgressPercentage());
    }

    private static enum EnumBaitStatus {
        NONE,
        REDUNDANT,
        REQUIRED;

    }

    private static enum EnumStatus {
        GREEN,
        YELLOW,
        RED;

    }
}

