/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.z_test_environment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.io.datapack.JsonDataLoader;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecipeTestDatapack
extends JsonDataLoader<TestData, TestDataRegistry> {
    private static TestDataDeserializer DESERIALIZER = new TestDataDeserializer();

    public RecipeTestDatapack(TestDataRegistry testDataRegistry) {
        super("valkyrielib", "test_data", TestData.class, testDataRegistry, new GsonBuilder().registerTypeAdapter(DESERIALIZER.getType(), (Object)DESERIALIZER).create());
    }

    @Override
    protected void handleException(VLID id, Exception e) {
    }

    public static class TestDataDeserializer
    implements ITypedDeserializer<TestData> {
        private TypeToken<TestData> tt = TypeToken.get(TestData.class);

        @Override
        public TypeToken<TestData> getTypeToken() {
            return this.tt;
        }

        @Override
        public String getTypeIdentifier() {
            return "testdata";
        }

        public TestData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }

    public static class TestDataRegistry
    implements IDataRegistryReloader<TestData> {
        private static TestDataRegistry INST;
        private Map<VLID, TestData> data = Maps.newConcurrentMap();
        private List<TestData> dataList = Lists.newArrayList();

        public static TestDataRegistry getInstance() {
            if (INST == null) {
                INST = new TestDataRegistry();
                MinecraftForge.EVENT_BUS.register((Object)INST);
            }
            return INST;
        }

        private TestDataRegistry() {
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load e) {
        }

        @Override
        public void reloadData(Map<VLID, TestData> loaded) {
            this.data = Maps.newConcurrentMap();
            this.dataList = Lists.newArrayList();
            this.data.putAll(loaded);
            this.dataList.addAll(loaded.values());
            for (TestData td : this.dataList) {
                if (td != null) continue;
            }
        }

        @Override
        public TestData merge(TestData left, TestData right) {
            return left;
        }
    }

    public static class TestData {
        public Provider<ItemStack> itemstack;
        public Provider<Integer> energy;
    }
}

