/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.VLib;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.network.IWritePacketData;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.modloader.util.SideUtil;
import com.valkyrieofnight.vlib.registry.RecipeRegistryManager;
import com.valkyrieofnight.vlib.registry.recipe.RecipeOverride;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import com.valkyrieofnight.vlib.registry.recipe.network.RecipePacket;
import com.valkyrieofnight.vlib.registry.recipe.type.IRecipeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractRecipeRegistry<RECIPE_TYPE extends VLRecipe>
implements IRecipeRegistry<RECIPE_TYPE>,
IDataRegistryReloader<RECIPE_TYPE>,
IWritePacketData {
    private final VLID id;
    private final Class<RECIPE_TYPE> recipeClass;
    private boolean serverStarted = false;

    public AbstractRecipeRegistry(String modid, String registryid, Class<RECIPE_TYPE> recipeClass) {
        this.id = new VLID(modid, registryid);
        this.recipeClass = recipeClass;
        RecipeRegistryManager.getInstance().register(this.id, this::readPacketData);
        try {
            this.recipeClass.getConstructor(PacketBuffer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The Recipe class provided in VLRecipeRegistry does not contain proper constructor for reloading recipes", e);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (SideUtil.isServer()) {
            MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        if (this.getAllRecipes(this.getID()) == null || this.getAllRecipes(this.getID()).size() < 1) {
            return;
        }
        RecipePacket packet = new RecipePacket(this);
        VLib.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), packet);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onServerStarted(FMLServerStartedEvent e) {
        this.serverStarted = true;
    }

    @Override
    public final RECIPE_TYPE merge(RECIPE_TYPE left, RECIPE_TYPE right) {
        RecipeOverride recipeOverride = ((VLRecipe)right).getOverride();
        if (recipeOverride == RecipeOverride.REPLACE) {
            return right;
        }
        if (recipeOverride == RecipeOverride.NONE) {
            return this.mergeNoOverride(left, right);
        }
        return null;
    }

    @Override
    public final void reloadData(Map<VLID, RECIPE_TYPE> loaded) {
        this.clearForNewData();
        if (loaded == null || loaded.size() < 1) {
            return;
        }
        ArrayList remove = Lists.newArrayList();
        loaded.forEach((k, v) -> {
            if (v.getOverride() == RecipeOverride.DISABLE) {
                remove.add(k);
            } else {
                v.setRecipeID((VLID)k);
            }
        });
        remove.forEach(vlid -> loaded.remove(vlid));
        this.loadDataIntoRegistry(loaded);
        if (SideUtil.isServer() && this.isServerStarted()) {
            RecipePacket packet = new RecipePacket(this);
            VLib.NETWORK_HANDLER.send(PacketDistributor.ALL.noArg(), packet);
        }
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        ArrayList f = Lists.newArrayList();
        for (VLRecipe r : this.getAllRecipes(this.getID())) {
            if (!r.canWriteData()) continue;
            f.add(r);
        }
        buffer.writeLong((long)f.size());
        for (VLRecipe r : f) {
            r.writePacketData(buffer);
        }
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        HashMap recipes = Maps.newHashMap();
        long recipeCount = buffer.readLong();
        for (long i = 0L; i < recipeCount; ++i) {
            RECIPE_TYPE recipe = this.createNew(buffer);
            if (recipe == null) continue;
            recipes.put(((VLRecipe)recipe).getRecipeID(), recipe);
        }
        this.reloadData(recipes);
    }

    private RECIPE_TYPE createNew(PacketBuffer buffer) {
        try {
            return (RECIPE_TYPE)((VLRecipe)this.recipeClass.getConstructor(PacketBuffer.class).newInstance(buffer));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void clearForNewData();

    protected abstract void loadDataIntoRegistry(Map<VLID, RECIPE_TYPE> var1);

    protected abstract RECIPE_TYPE mergeNoOverride(RECIPE_TYPE var1, RECIPE_TYPE var2);

    public VLID getID() {
        return this.id;
    }

    public final String getModID() {
        return this.id.func_110624_b();
    }

    public final String getRegistryName() {
        return this.id.getLocation();
    }

    public final Class<RECIPE_TYPE> getRecipeClass() {
        return this.recipeClass;
    }

    public boolean isServerStarted() {
        return this.serverStarted;
    }
}

