/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.value;

import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionID;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.value.ValueProviderDeserializers;
import net.minecraft.network.PacketBuffer;

public abstract class ValueProvider<RETURN_TYPE>
extends Provider<RETURN_TYPE> {
    protected ConditionID condition;
    protected ConditionScope scope;
    protected RETURN_TYPE defaultData;

    public ValueProvider(ConditionID id, ConditionScope scope, RETURN_TYPE defaultData) {
        this.condition = id;
        this.scope = scope;
        this.defaultData = defaultData;
    }

    public ValueProvider(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(this.condition.toString());
        buffer.func_179249_a((Enum)this.scope);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.condition = ConditionID.fromString(buffer.func_218666_n());
        this.scope = (ConditionScope)buffer.func_179257_a(ConditionScope.class);
        this.readData(buffer);
    }

    protected abstract void readData(PacketBuffer var1);

    public static class String
    extends ValueProvider<java.lang.String> {
        public String(ConditionID id, ConditionScope scope, java.lang.String defaultData) {
            super(id, scope, defaultData);
        }

        public String(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.STRING.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.func_180714_a((java.lang.String)this.defaultData);
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.func_218666_n();
        }

        @Override
        public java.lang.String request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.String)container.getStringCondition(this.condition).getValue() : (java.lang.String)this.defaultData;
        }
    }

    public static class Char
    extends ValueProvider<Character> {
        public Char(ConditionID id, ConditionScope scope, Character defaultData) {
            super(id, scope, defaultData);
        }

        public Char(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.CHAR.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeChar((int)((Character)this.defaultData).charValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = Character.valueOf(buffer.readChar());
        }

        @Override
        public Character request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (Character)container.getCharCondition(this.condition).getValue() : (Character)this.defaultData;
        }
    }

    public static class Double
    extends ValueProvider<java.lang.Double> {
        public Double(ConditionID id, ConditionScope scope, java.lang.Double defaultData) {
            super(id, scope, defaultData);
        }

        public Double(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.DOUBLE.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeDouble(((java.lang.Double)this.defaultData).doubleValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readDouble();
        }

        @Override
        public java.lang.Double request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Double)container.getDoubleCondition(this.condition).getValue() : (java.lang.Double)this.defaultData;
        }
    }

    public static class Float
    extends ValueProvider<java.lang.Float> {
        public Float(ConditionID id, ConditionScope scope, java.lang.Float defaultData) {
            super(id, scope, defaultData);
        }

        public Float(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.FLOAT.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeFloat(((java.lang.Float)this.defaultData).floatValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = java.lang.Float.valueOf(buffer.readFloat());
        }

        @Override
        public java.lang.Float request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Float)container.getFloatCondition(this.condition).getValue() : (java.lang.Float)this.defaultData;
        }
    }

    public static class Long
    extends ValueProvider<java.lang.Long> {
        public Long(ConditionID id, ConditionScope scope, java.lang.Long defaultData) {
            super(id, scope, defaultData);
        }

        public Long(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.LONG.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeLong(((java.lang.Long)this.defaultData).longValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readLong();
        }

        @Override
        public java.lang.Long request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Long)container.getLongCondition(this.condition).getValue() : (java.lang.Long)this.defaultData;
        }
    }

    public static class Int
    extends ValueProvider<Integer> {
        public Int(ConditionID id, ConditionScope scope, Integer defaultData) {
            super(id, scope, defaultData);
        }

        public Int(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.INT.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeInt(((Integer)this.defaultData).intValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readInt();
        }

        @Override
        public Integer request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (Integer)container.getIntCondition(this.condition).getValue() : (Integer)this.defaultData;
        }
    }

    public static class Short
    extends ValueProvider<java.lang.Short> {
        public Short(ConditionID id, ConditionScope scope, java.lang.Short defaultData) {
            super(id, scope, defaultData);
        }

        public Short(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.SHORT.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeShort((int)((java.lang.Short)this.defaultData).shortValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readShort();
        }

        @Override
        public java.lang.Short request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Short)container.getShortCondition(this.condition).getValue() : (java.lang.Short)this.defaultData;
        }
    }

    public static class Byte
    extends ValueProvider<java.lang.Byte> {
        public Byte(ConditionID id, ConditionScope scope, java.lang.Byte defaultData) {
            super(id, scope, defaultData);
        }

        public Byte(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.BYTE.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeByte((int)((java.lang.Byte)this.defaultData).byteValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readByte();
        }

        @Override
        public java.lang.Byte request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Byte)container.getByteCondition(this.condition).getValue() : (java.lang.Byte)this.defaultData;
        }
    }

    public static class Boolean
    extends ValueProvider<java.lang.Boolean> {
        public Boolean(ConditionID id, ConditionScope scope, java.lang.Boolean defaultData) {
            super(id, scope, defaultData);
        }

        public Boolean(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(ValueProviderDeserializers.BOOLEAN.getTypeIdentifier());
            super.writePacketData(buffer);
            buffer.writeBoolean(((java.lang.Boolean)this.defaultData).booleanValue());
        }

        @Override
        protected void readData(PacketBuffer buffer) {
            this.defaultData = buffer.readBoolean();
        }

        @Override
        public java.lang.Boolean request(ConditionContainerProvider dataContainer) {
            ConditionDataContainer container = dataContainer.get(this.scope);
            return container != null ? (java.lang.Boolean)container.getBooleanCondition(this.condition).getValue() : (java.lang.Boolean)this.defaultData;
        }
    }
}

