/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.stack;

import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public class ItemStackProvider
extends Provider<ItemStack> {
    private Provider<Item> item;
    private Provider<Integer> stackSize;
    private Provider<CompoundNBT> nbt;

    public ItemStackProvider(Provider<Item> item, Provider<Integer> stackSize, Provider<CompoundNBT> nbt) {
        this.item = item;
        this.stackSize = stackSize;
        this.nbt = nbt;
    }

    public ItemStackProvider(Provider<Item> item, Provider<Integer> stackSize) {
        this(item, stackSize, null);
    }

    public ItemStackProvider(Provider<Item> item) {
        this(item, null, null);
    }

    @Override
    public ItemStack request(ConditionContainerProvider dataContainer) {
        Item i = this.item.request(dataContainer);
        Integer ss = 0;
        if (this.stackSize != null) {
            ss = this.stackSize.request(dataContainer);
        }
        CompoundNBT nbt = null;
        if (this.nbt != null) {
            nbt = this.nbt.request(dataContainer);
        }
        return new ItemStack((IItemProvider)i, ss.intValue(), nbt);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        this.item.writePacketData(buffer);
        buffer.writeBoolean(this.stackSize != null);
        if (this.stackSize != null) {
            this.stackSize.writePacketData(buffer);
        }
        buffer.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            this.nbt.writePacketData(buffer);
        }
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        boolean containsNBT;
        this.item = DeserializerUtils.readProviderFromPacket(buffer);
        boolean containsStackSize = buffer.readBoolean();
        if (containsStackSize) {
            this.stackSize = DeserializerUtils.readProviderFromPacket(buffer);
        }
        if (containsNBT = buffer.readBoolean()) {
            this.nbt = DeserializerUtils.readProviderFromPacket(buffer);
        }
    }
}

