/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.stack;

import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackProvider
extends Provider<FluidStack> {
    private Provider<Fluid> fluid;
    private Provider<Integer> stackSize;
    private Provider<CompoundNBT> nbt;

    public FluidStackProvider(Provider<Fluid> fluid, Provider<Integer> stackSize, Provider<CompoundNBT> nbt) {
        this.fluid = fluid;
        this.stackSize = stackSize;
        this.nbt = nbt;
    }

    public FluidStackProvider(Provider<Fluid> fluid, Provider<Integer> stackSize) {
        this(fluid, stackSize, null);
    }

    public FluidStackProvider(Provider<Fluid> fluid) {
        this(fluid, null, null);
    }

    @Override
    public FluidStack request(ConditionContainerProvider dataContainer) {
        Fluid f = this.fluid.request(dataContainer);
        Integer ss = 0;
        if (this.stackSize != null) {
            ss = this.stackSize.request(dataContainer);
        }
        CompoundNBT nbt = null;
        if (this.nbt != null) {
            nbt = this.nbt.request(dataContainer);
        }
        return new FluidStack(f, ss.intValue(), nbt);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        this.fluid.writePacketData(buffer);
        buffer.writeBoolean(this.stackSize != null);
        if (this.stackSize != null) {
            this.stackSize.writePacketData(buffer);
        }
        buffer.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            this.nbt.writePacketData(buffer);
        }
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        boolean containsNBT;
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        this.fluid = DeserializerUtils.readProviderFromPacket(buffer);
        boolean containsStackSize = buffer.readBoolean();
        if (containsStackSize) {
            this.stackSize = DeserializerUtils.readProviderFromPacket(buffer);
        }
        if (containsNBT = buffer.readBoolean()) {
            this.nbt = DeserializerUtils.readProviderFromPacket(buffer);
        }
    }
}

