/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers.stack;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import com.valkyrieofnight.vlib.registry.provider.stack.FluidStackProvider;
import com.valkyrieofnight.vlib.registry.provider.stack.ItemStackProvider;
import java.lang.reflect.Type;

public class DynamicStackProviderDeserializer {
    public static final String TYPE = "dynamic_stack";
    public static final String ITEM_COUNT_IDENTIFIER = "count";
    public static final String FLUID_AMOUNT_IDENTIFIER = "amount";
    public static final String NBT_IDENTIFIER = "nbt";
    public static final ProviderDeserializer<ItemStackProvider> ITEMSTACK = new ProviderDeserializer<ItemStackProvider>(ItemStackProvider.class, "dynamic_stack:itemstack"){

        public ItemStackProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String dst;
                    Type it;
                    JsonObject io = JsonUtils.getAsJsonObject(jo, this.getTypeIdentifier());
                    Type type = it = io != null ? DeserializerUtils.getDeserializerTypeFromObject(io) : null;
                    if (it == null) {
                        throw new JsonParseException("Failed to find Deserializer for JsonObject: " + io);
                    }
                    JsonObject so = JsonUtils.getAsJsonObject(jo, DynamicStackProviderDeserializer.ITEM_COUNT_IDENTIFIER);
                    Type st = so != null ? DeserializerUtils.getDeserializerTypeFromObject(so) : null;
                    String string = dst = st != null ? ProviderDeserializerRegistry.getInstance().getDataReturnType(st) : null;
                    if (!StringUtils.isNullOrEmpty(dst) && !dst.equals("int")) {
                        throw new JsonParseException("Could not load stack size, provided data type: " + dst);
                    }
                    JsonObject no = JsonUtils.getAsJsonObject(jo, DynamicStackProviderDeserializer.NBT_IDENTIFIER);
                    Type nt = no != null ? DeserializerUtils.getDeserializerTypeFromObject(no) : null;
                    Provider ilp = (Provider)context.deserialize((JsonElement)io, it);
                    Provider ssp = (Provider)context.deserialize((JsonElement)so, st);
                    Provider nbp = no != null ? (Provider)context.deserialize((JsonElement)no, nt) : null;
                    return new ItemStackProvider(ilp, ssp, nbp);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            throw new JsonParseException("Could not deserialize json into FluidStack");
        }
    };
    public static final ProviderDeserializer<FluidStackProvider> FLUIDSTACK = new ProviderDeserializer<FluidStackProvider>(FluidStackProvider.class, "dynamic_stack:fluidstack"){

        public FluidStackProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = (JsonObject)json;
                try {
                    String dst;
                    Type ft;
                    JsonObject fo = JsonUtils.getAsJsonObject(jo, this.getTypeIdentifier());
                    Type type = ft = fo != null ? DeserializerUtils.getDeserializerTypeFromObject(fo) : null;
                    if (ft == null) {
                        throw new JsonParseException("Failed to find Deserializer for JsonObject: " + fo);
                    }
                    JsonObject so = JsonUtils.getAsJsonObject(jo, DynamicStackProviderDeserializer.FLUID_AMOUNT_IDENTIFIER);
                    Type st = so != null ? DeserializerUtils.getDeserializerTypeFromObject(so) : null;
                    String string = dst = st != null ? ProviderDeserializerRegistry.getInstance().getDataReturnType(st) : null;
                    if (!StringUtils.isNullOrEmpty(dst) && !dst.equals("int")) {
                        throw new JsonParseException("Could not load stack size, provided data type: " + dst);
                    }
                    JsonObject no = JsonUtils.getAsJsonObject(jo, DynamicStackProviderDeserializer.NBT_IDENTIFIER);
                    Type nt = no != null ? DeserializerUtils.getDeserializerTypeFromObject(no) : null;
                    Provider flp = (Provider)context.deserialize((JsonElement)fo, ft);
                    Provider ssp = (Provider)context.deserialize((JsonElement)so, st);
                    Provider nbp = no != null ? (Provider)context.deserialize((JsonElement)no, nt) : null;
                    return new FluidStackProvider(flp, ssp, nbp);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            throw new JsonParseException("Could not deserialize json into FluidStack");
        }
    };
}

