/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.item;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ItemStackProviderIngredient
extends Ingredient<ItemStack> {
    private Provider<ItemStack> provider;
    private Provider<Integer> count;
    private boolean matchNBT;

    public ItemStackProviderIngredient(@NotNull Provider<ItemStack> stackProvider, @NotNull Provider<Integer> count, boolean matchNBT) {
        this.provider = stackProvider;
        this.count = count;
        this.matchNBT = matchNBT;
    }

    public ItemStackProviderIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, ItemStack test) {
        if (test == null) {
            return false;
        }
        ItemStack pis = this.provider.request(provider);
        if (this.matchNBT) {
            return ItemStack.func_179545_c((ItemStack)pis, (ItemStack)test) && ItemStack.func_77970_a((ItemStack)pis, (ItemStack)test) && test.func_190916_E() >= this.requestAmount(provider);
        }
        return ItemStack.func_179545_c((ItemStack)pis, (ItemStack)test) && test.func_190916_E() >= this.requestAmount(provider);
    }

    @Override
    public List<ItemStack> request(@NotNull ConditionContainerProvider provider) {
        ItemStack copy = this.provider.request(provider).func_77946_l();
        copy.func_190920_e(this.requestAmount(provider));
        return Collections.singletonList(copy);
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.count.request(provider);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(ItemStackProviderIngredient.getFromClass(this.getClass()));
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        buffer.func_180714_a(PDR.getTypeIdentifier(this.provider.getClass()));
        this.provider.writePacketData(buffer);
        buffer.func_180714_a(PDR.getTypeIdentifier(this.count.getClass()));
        this.count.writePacketData(buffer);
        buffer.writeBoolean(this.matchNBT);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        ProviderDeserializer ppd = PDR.getFromType(buffer.func_218666_n());
        this.provider = ppd.createFromPacket(buffer);
        ProviderDeserializer cpd = PDR.getFromType(buffer.func_218666_n());
        this.count = cpd.createFromPacket(buffer);
        this.matchNBT = buffer.readBoolean();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "{stack_provider:" + this.provider + ",count_provider:" + this.count + "}";
    }
}

