/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.item;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public class ItemProviderIngredient
extends Ingredient<ItemStack> {
    private Provider<Item> provider;
    private Provider<Integer> count;

    public ItemProviderIngredient(@NotNull Provider<Item> itemProvider, Provider<Integer> count) {
        this.provider = itemProvider;
        this.count = count;
    }

    public ItemProviderIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, ItemStack test) {
        return test != null ? this.provider.request(provider).equals(test.func_77973_b()) && test.func_190916_E() >= this.count.request(provider) : false;
    }

    @Override
    public List<ItemStack> request(@NotNull ConditionContainerProvider provider) {
        return Collections.singletonList(new ItemStack((IItemProvider)this.provider.request(provider), this.requestAmount(provider)));
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.count.request(provider);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(ItemProviderIngredient.getFromClass(this.getClass()));
        DeserializerUtils.writeProviderToPacket(this.provider, buffer);
        DeserializerUtils.writeProviderToPacket(this.count, buffer);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.provider = DeserializerUtils.readProviderFromPacket(buffer);
        this.count = DeserializerUtils.readProviderFromPacket(buffer);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "{item_provider:" + this.provider + ",count_provider:" + this.count + "}";
    }
}

