/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.fluid;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackIngredient
extends Ingredient<FluidStack> {
    private FluidStack fluidStack;
    private int amount;
    private boolean matchNBT;

    public FluidStackIngredient(FluidStack fluidStack, int amount, boolean matchNBT) {
        this.fluidStack = fluidStack;
        this.amount = amount;
        this.matchNBT = matchNBT;
    }

    public FluidStackIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, FluidStack test) {
        return test != null ? this.fluidStack.isFluidEqual(test) && test.getAmount() >= this.requestAmount(provider) : false;
    }

    @Override
    public List<FluidStack> request(@NotNull ConditionContainerProvider provider) {
        return Collections.singletonList(this.fluidStack);
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.amount;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(FluidStackIngredient.getFromClass(this.getClass()));
        buffer.writeFluidStack(this.fluidStack);
        buffer.writeInt(this.amount);
        buffer.writeBoolean(this.matchNBT);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.fluidStack = buffer.readFluidStack();
        this.amount = buffer.readInt();
        this.matchNBT = buffer.readBoolean();
    }

    @Override
    public boolean isValid() {
        return this.fluidStack != FluidStack.EMPTY && this.fluidStack != null;
    }
}

