/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.block;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.obj.TagUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.ingredient.TagIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class BlockTagIngredient
extends TagIngredient<Block> {
    protected VLID tag;

    public BlockTagIngredient(@NotNull VLID tag, Ingredient.TagIngredientType selector) {
        super(selector);
        this.tag = tag;
    }

    public BlockTagIngredient(@NotNull VLID tag, Ingredient.TagIngredientType selector, @NotNull String[] values) {
        super(selector, values);
        this.tag = tag;
    }

    public BlockTagIngredient(PacketBuffer buffer) {
        super(buffer);
    }

    private ITag<Block> getTag() {
        return TagUtils.getBlockTag(this.tag);
    }

    @Override
    public int getTotalTagEntries() {
        ITag<Block> tag = this.getTag();
        return tag != null ? tag.func_230236_b_().size() : 0;
    }

    @Override
    protected void writeOtherPacketData(PacketBuffer buffer) {
        buffer.func_180714_a(BlockTagIngredient.getFromClass(this.getClass()));
        buffer.func_192572_a((ResourceLocation)this.tag);
    }

    @Override
    protected void readOtherPacketData(PacketBuffer buffer) {
        this.tag = VLID.from(buffer.func_192575_l());
    }

    @Override
    public boolean test(ConditionContainerProvider provider, Block test) {
        return test != null && this.isValid() ? this.getTag().func_230235_a_((Object)test.getBlock()) : false;
    }

    @Override
    public List<Block> request(@NotNull ConditionContainerProvider provider) {
        ArrayList list = Lists.newArrayList();
        ITag<Block> tag = this.getTag();
        switch (this.selector) {
            case ALL_WHITELISTED: {
                if (!StringUtils.isNullOrEmpty(this.properties[0])) {
                    TagUtils.addBlockAllNamespaces(list, tag, this.properties[0]);
                    break;
                }
                TagUtils.addBlockAll(list, tag);
                break;
            }
            case ALL: {
                TagUtils.addBlockAll(list, tag);
                break;
            }
            case FIRST_WHITELISTED: {
                if (!StringUtils.isNullOrEmpty(this.properties[0])) {
                    TagUtils.addBlockFirstNamespace(list, tag, this.properties[0]);
                    break;
                }
                TagUtils.addBlockAll(list, tag);
                break;
            }
            case FIRST: {
                TagUtils.addFirstBlock(list, tag);
                break;
            }
            case FIRST_PREFERRED: {
                TagUtils.addBlockPreferred(list, tag, this.properties);
                break;
            }
            case FIRST_WITH_BLACKLIST: {
                TagUtils.addBlockFirstWithBlacklist(list, tag, this.properties);
                break;
            }
            case ALL_WITH_BLACKLIST: {
                TagUtils.addAllBlockWithBlacklist(list, tag, this.properties);
            }
        }
        return list;
    }

    @Override
    public int requestAmount(ConditionContainerProvider provider) {
        return 1;
    }

    @Override
    public boolean isValid() {
        ITag<Block> tag = this.getTag();
        return tag != null && tag.func_230236_b_().size() > 0;
    }
}

