/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.network.IWritePacketData;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockTagIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidStackIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidStackProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidTagIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemStackIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemStackProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemTagIngredient;
import java.util.List;
import java.util.Map;
import net.minecraft.network.PacketBuffer;

public abstract class Ingredient<TEST_TYPE>
implements IWritePacketData {
    private static volatile Map<Class<? extends Ingredient<?>>, String> classToID = Maps.newConcurrentMap();
    private static volatile Map<String, Class<? extends Ingredient<?>>> ingredientMap = Maps.newHashMap();

    public static String getFromClass(Class<? extends Ingredient<?>> clazz) {
        if (!classToID.containsKey(clazz)) {
            return "null";
        }
        return classToID.get(clazz);
    }

    public static Ingredient createFromPacket(PacketBuffer buffer) {
        return Ingredient.createFromPacket(buffer.func_218666_n(), buffer);
    }

    private static Ingredient createFromPacket(String id, PacketBuffer buffer) {
        try {
            Class<Ingredient<?>> cl;
            Class<Ingredient<?>> clazz = cl = ingredientMap.containsKey(id) ? ingredientMap.get(id) : null;
            if (cl != null) {
                Ingredient<?> i = cl.getConstructor(PacketBuffer.class).newInstance(buffer);
                return i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Ingredient(PacketBuffer buffer) {
        this.readPacketData(buffer);
    }

    public Ingredient() {
    }

    public abstract boolean test(@NotNull ConditionContainerProvider var1, TEST_TYPE var2);

    public abstract List<TEST_TYPE> request(@NotNull ConditionContainerProvider var1);

    public abstract int requestAmount(@NotNull ConditionContainerProvider var1);

    public abstract boolean isValid();

    static {
        classToID.put(ItemIngredient.class, "i:item");
        classToID.put(ItemProviderIngredient.class, "i:itemprovider");
        classToID.put(ItemStackIngredient.class, "i:itemstack");
        classToID.put(ItemStackProviderIngredient.class, "i:itemstackprovider");
        classToID.put(ItemTagIngredient.class, "i:itemtag");
        classToID.put(FluidIngredient.class, "i:fluid");
        classToID.put(FluidProviderIngredient.class, "i:fluidprovider");
        classToID.put(FluidStackIngredient.class, "i:fluidstack");
        classToID.put(FluidStackProviderIngredient.class, "i:fluidstackprovider");
        classToID.put(FluidTagIngredient.class, "i:fluidtag");
        classToID.put(BlockIngredient.class, "i:block");
        classToID.put(BlockProviderIngredient.class, "i:blockprovider");
        classToID.put(BlockTagIngredient.class, "i:blocktag");
        ingredientMap.put("i:item", ItemIngredient.class);
        ingredientMap.put("i:itemprovider", ItemProviderIngredient.class);
        ingredientMap.put("i:itemstack", ItemStackIngredient.class);
        ingredientMap.put("i:itemstackprovider", ItemStackProviderIngredient.class);
        ingredientMap.put("i:itemtag", ItemTagIngredient.class);
        ingredientMap.put("i:fluid", FluidIngredient.class);
        ingredientMap.put("i:fluidprovider", FluidProviderIngredient.class);
        ingredientMap.put("i:fluidstack", FluidStackIngredient.class);
        ingredientMap.put("i:fluidstackprovider", FluidStackProviderIngredient.class);
        ingredientMap.put("i:fluidtag", FluidTagIngredient.class);
        ingredientMap.put("i:block", BlockIngredient.class);
        ingredientMap.put("i:blockprovider", BlockProviderIngredient.class);
        ingredientMap.put("i:blocktag", BlockTagIngredient.class);
    }

    public static enum TagIngredientType {
        ALL("all", false, true),
        ALL_WHITELISTED("all_whitelisted", true, true),
        ALL_WITH_BLACKLIST("all_with_blacklist", true, true),
        FIRST("first", false, false),
        FIRST_WHITELISTED("first_whitelisted", true, false),
        FIRST_PREFERRED("first_preferred", true, false),
        FIRST_WITH_BLACKLIST("first_with_blacklist", true, false);

        private final String name;
        private boolean hasProperty;
        private boolean hasMultiple;
        private static TagIngredientType[] ALL_VALUES;

        private TagIngredientType(String name, boolean hasProperty, boolean hasMultiple) {
            this.name = name;
            this.hasProperty = hasProperty;
            this.hasMultiple = hasMultiple;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasProperty() {
            return this.hasProperty;
        }

        public boolean hasMultiple() {
            return this.hasMultiple;
        }

        public static TagIngredientType getFromOrdinal(int ordinal) {
            return ALL_VALUES[ordinal % ALL_VALUES.length];
        }

        public static TagIngredientType getFromName(@NotNull String name) {
            if (name.equalsIgnoreCase("first")) {
                return FIRST;
            }
            if (name.equalsIgnoreCase("first_whitelisted")) {
                return FIRST_WHITELISTED;
            }
            if (name.equalsIgnoreCase("first_preferred")) {
                return FIRST_PREFERRED;
            }
            if (name.equalsIgnoreCase("first_with_blacklist")) {
                return FIRST_WITH_BLACKLIST;
            }
            if (name.equalsIgnoreCase("all")) {
                return ALL;
            }
            if (name.equalsIgnoreCase("all_whitelisted")) {
                return ALL_WHITELISTED;
            }
            if (name.equalsIgnoreCase("all_with_blacklist")) {
                return ALL_WITH_BLACKLIST;
            }
            return null;
        }

        public static TagIngredientType getFromNameOrDefault(@NotNull String name, TagIngredientType def) {
            TagIngredientType ret = TagIngredientType.getFromName(name);
            return ret == null ? def : ret;
        }

        static {
            ALL_VALUES = TagIngredientType.values();
        }
    }
}

