/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.obj.tile.impl.colored;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorProviderTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorableTile;
import com.valkyrieofnight.vlib.core.util.CollectionUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.multiblock.obj.tile.impl.SlaveTile;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class MultiColoredSlaveTile
extends SlaveTile
implements IColorableTile,
IColorProviderTile {
    protected Color4[] colors;
    private final List<Integer> colorable;
    private final int[] colorableArray;
    private final int[] allChannels;

    public MultiColoredSlaveTile(TileEntityType<?> blockEntityType_1, Color4[] colors, int[] colorable, int[] allChannels) {
        super(blockEntityType_1);
        this.colors = colors;
        this.colorable = CollectionUtils.toArrayList(colorable);
        this.colorableArray = colorable;
        this.allChannels = allChannels;
    }

    @Override
    public void setColor(int channel, int color) {
        if (this.colorable.contains(channel)) {
            this.colors[MathUtil.clamp((int)channel, (int)0, (int)this.getAllColorChannels().length)] = new Color4(color);
        }
    }

    @Override
    public int getColor(int i) {
        return this.colors[MathUtil.clamp(i, 0, this.getAllColorChannels().length)].getRGBA();
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        if (type != SaveDataType.ITEM) {
            CompoundNBT colorNBT = new CompoundNBT();
            for (int i = 0; i < this.colors.length; ++i) {
                if (this.colors[i] == Color4.WHITE) continue;
                colorNBT.func_74768_a("" + i, this.colors[i].getRGBA());
            }
            if (!colorNBT.isEmpty()) {
                nbt.func_218657_a("colors", (INBT)colorNBT);
            }
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (type != SaveDataType.ITEM && nbt.func_74764_b("colors")) {
            CompoundNBT colorNBT = nbt.func_74775_l("colors");
            for (int i = 0; i < this.colors.length; ++i) {
                if (!colorNBT.func_74764_b("" + i)) continue;
                this.colors[i] = new Color4(colorNBT.func_74762_e("" + i));
            }
        }
        super.load(nbt, type);
    }

    @Override
    public int[] getAllColorableChannels() {
        return this.colorableArray;
    }

    @Override
    public int[] getAllColorChannels() {
        return this.allChannels;
    }
}

