/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.obj.tile.impl.colored;

import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorProviderBlock;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorProviderTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorableTile;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.multiblock.obj.tile.impl.SlaveTile;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public class ColoredSlaveTile
extends SlaveTile
implements IColorableTile,
IColorProviderTile {
    private static int[] colorChannels = new int[]{0};
    private Color4 color = new Color4();

    public ColoredSlaveTile(TileEntityType<?> blockEntityType_1) {
        super(blockEntityType_1);
        this.color = new Color4(255, 255, 255);
    }

    public ColoredSlaveTile(TileEntityType<?> blockEntityType_1, Color4 defaultColor) {
        super(blockEntityType_1);
        this.color = defaultColor;
    }

    @Override
    public CompoundNBT save(CompoundNBT compound, SaveDataType type) {
        super.save(compound, type);
        if (!(type == SaveDataType.ITEM || this.color.equals(Color4.WHITE) && this.color.getRGBA() == 0 && this.color.getRGBA() == -1)) {
            CompoundNBT colors = NBTBuilder.create().putInt("0", this.color.getRGBA()).build();
            compound.func_218657_a("colors", (INBT)colors);
        }
        return compound;
    }

    @Override
    public void load(CompoundNBT compound, SaveDataType type) {
        CompoundNBT colors;
        if (type != SaveDataType.ITEM && compound.func_74764_b("colors") && (colors = compound.func_74775_l("colors")).func_74764_b("0")) {
            this.color = new Color4(colors.func_74762_e("0"));
        }
        super.load(compound, type);
    }

    @Override
    public void setColor(int channel, int i) {
        if (channel == 0) {
            this.color = new Color4(i);
        }
    }

    @Override
    public int[] getAllColorableChannels() {
        return colorChannels;
    }

    @Override
    public int[] getAllColorChannels() {
        Block blk = this.func_195044_w().func_177230_c();
        return ((IColorProviderBlock)blk).getAllColorChannels();
    }

    @Override
    public int getColor(int channel) {
        if (channel == 0) {
            return this.color.getRGBA();
        }
        return 0;
    }
}

