/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.obj.tile.impl.colored;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorProviderTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorableTile;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.multiblock.obj.tile.impl.ControllerTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class ColoredControllerTile
extends ControllerTile
implements IColorableTile,
IColorProviderTile {
    private static int[] colorChannels = new int[]{0, 1};
    protected Color4[] colors = new Color4[]{Color4.WHITE, Color4.WHITE};

    public ColoredControllerTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void setColor(int channel, int i) {
        switch (channel) {
            case 0: {
                this.colors[0] = new Color4(i);
                break;
            }
            case 1: {
                this.colors[1] = new Color4(i);
            }
        }
    }

    @Override
    public int getColor(int channel) {
        switch (channel) {
            case 0: {
                return this.colors[0].getRGBA();
            }
            case 1: {
                return this.colors[1].getRGBA();
            }
        }
        return 0;
    }

    @Override
    public CompoundNBT save(CompoundNBT compound, SaveDataType type) {
        super.save(compound, type);
        if (type != SaveDataType.ITEM) {
            CompoundNBT colors = NBTBuilder.create().putInt("0", this.colors[0].getRGBA()).putInt("1", this.colors[1].getRGBA()).build();
            compound.func_218657_a("colors", (INBT)colors);
        }
        return compound;
    }

    @Override
    public void load(CompoundNBT compound, SaveDataType type) {
        super.load(compound, type);
        if (type != SaveDataType.ITEM && compound.func_74764_b("colors")) {
            CompoundNBT colors = compound.func_74775_l("colors");
            if (colors.func_74764_b("0")) {
                this.colors[0] = new Color4(colors.func_74762_e("0"));
            }
            if (colors.func_74764_b("1")) {
                this.colors[1] = new Color4(colors.func_74762_e("1"));
            }
        }
    }

    @Override
    public int[] getAllColorChannels() {
        return colorChannels;
    }

    @Override
    public int[] getAllColorableChannels() {
        return this.getAllColorChannels();
    }
}

