/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.multiblock.Structure;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StructureMap {
    private final VLID structureID;
    protected volatile ConcurrentMap<Integer, Structure> structures = Maps.newConcurrentMap();

    public StructureMap(VLID structureID) {
        this.structureID = structureID;
    }

    public StructureMap addTier(int tier, Structure structure) {
        if (!this.structures.containsKey(tier)) {
            this.structures.put(tier, structure);
        }
        return this;
    }

    @Nullable
    public Structure getStructure(int id) {
        return this.structures.containsKey(id) ? (Structure)this.structures.get(id) : null;
    }

    public Collection<Integer> getIDList() {
        return this.structures.keySet();
    }

    public boolean hasStructure(int tier) {
        return this.structures.containsKey(tier);
    }

    public ITextComponent getListTitle() {
        return new TranslationTextComponent("multiblock." + this.structureID.func_110624_b() + "." + this.structureID.getLocation() + ".strucute.list");
    }
}

