/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.fluid.util;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ForgeFluidUtil {
    public static IFluidHandler getFluidHandlerFromItemStack(ItemStack itemStack) {
        AtomicReference fluidHandlerAtomicReference = new AtomicReference();
        itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandlerAtomicReference::set);
        if (fluidHandlerAtomicReference.get() != null) {
            itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandlerAtomicReference::set);
        }
        return (IFluidHandler)fluidHandlerAtomicReference.get();
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        if (fluidDestination instanceof FluidBucketWrapper || fluidSource instanceof FluidBucketWrapper) {
            if (maxAmount < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack drainable = fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
            int insertable = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
            if (insertable != 1000) {
                return FluidStack.EMPTY;
            }
            if (doTransfer) {
                fluidDestination.fill(fluidSource.drain(insertable, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                return drainable;
            }
            return FluidStack.EMPTY;
        }
        return FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)doTransfer);
    }
}

