/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.fluid.tile;

import com.valkyrieofnight.vlib.core.obj.container.IOHandler;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IConfigurableIORate;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.obj.FluidUtils;
import com.valkyrieofnight.vlib.integration.forge.fluid.IConfigurableIORateForgeFluid;
import com.valkyrieofnight.vlib.integration.forge.fluid.IVLFluidTank;
import com.valkyrieofnight.vlib.integration.forge.fluid.util.ForgeFluidUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidIOHandler
extends IOHandler {
    private final IVLFluidTank internalTank;
    private int internalTankInputRate = Integer.MAX_VALUE;
    private int internalTankOutputRate = Integer.MAX_VALUE;

    public FluidIOHandler(IInventory ioSlots, EnumIO ioMode, IVLFluidTank internalTank) {
        super(ioSlots, ioMode);
        this.internalTank = internalTank;
    }

    public FluidIOHandler(IInventory ioSlots, EnumIO ioMode, IVLFluidTank internalTank, Action setChangedMethod) {
        super(ioSlots, ioMode, setChangedMethod);
        this.internalTank = internalTank;
    }

    @Override
    public int getItemStorageMinimumTransferUnitSize(ItemStack itemStack) {
        if (FluidUtils.isBucket(itemStack)) {
            return 1000;
        }
        return super.getItemStorageMinimumTransferUnitSize(itemStack);
    }

    @Override
    public int transferFromItemStorageToInternalStorage(ItemStack itemStack, int maxAmount) {
        if (FluidUtils.isBucket(itemStack) && maxAmount < 1000) {
            return 0;
        }
        FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this.internalTank, (int)maxAmount, null, (boolean)true);
        if (fluidActionResult.isSuccess()) {
            this.ioSlots.func_70299_a(this.bufferSlotIndex, fluidActionResult.getResult());
            int amountTransferred = this.getItemStorageStoredAmount(itemStack) - this.getItemStorageStoredAmount(fluidActionResult.getResult());
            IFluidHandler itemStackFluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
            if (itemStackFluidHandler != null) {
                itemStackFluidHandler.drain(amountTransferred, IFluidHandler.FluidAction.EXECUTE);
            }
            return amountTransferred;
        }
        this.ioSlots.func_70299_a(this.bufferSlotIndex, itemStack);
        return 0;
    }

    @Override
    public int transferFromInternalStorageToItemStorage(ItemStack itemStack, int maxAmount) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            return ForgeFluidUtil.tryFluidTransfer(fluidHandler, this.internalTank, maxAmount, true).getAmount();
        }
        return 0;
    }

    @Override
    public boolean isInternalStorageEmpty() {
        return this.internalTank.getFluidInTank(0).isEmpty();
    }

    @Override
    public boolean isInternalStorageFull() {
        return this.internalTank.getFluidInTank(0).getAmount() == this.internalTank.getTankCapacity(0);
    }

    @Override
    public boolean isItemStorageEmpty(ItemStack itemStack) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).getAmount() == 0;
        }
        return true;
    }

    @Override
    public boolean isItemStorageFull(ItemStack itemStack) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).getAmount() == fluidHandler.getTankCapacity(0);
        }
        return true;
    }

    @Override
    public int getInternalStorageStoredAmount() {
        return this.internalTank.getFluidInTank(0).getAmount();
    }

    @Override
    public int getItemStorageStoredAmount(ItemStack itemStack) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).getAmount();
        }
        return 0;
    }

    @Override
    public int getInternalStorageInputRate() {
        if (this.internalTank instanceof IConfigurableIORateForgeFluid) {
            return ((IConfigurableIORate)((Object)this.internalTank)).getInputRate();
        }
        return this.internalTankInputRate;
    }

    @Override
    public int getInternalStorageOutputRate() {
        if (this.internalTank instanceof IConfigurableIORate) {
            return ((IConfigurableIORate)((Object)this.internalTank)).getOutputRate();
        }
        return this.internalTankOutputRate;
    }

    public void setInternalStorageInputRate(int rate) {
        if (this.internalTank instanceof IConfigurableIORate) {
            ((IConfigurableIORate)((Object)this.internalTank)).setInputRate(rate);
        } else {
            this.internalTankInputRate = rate;
        }
    }

    public void setInternalStorageOutputRate(int rate) {
        if (this.internalTank instanceof IConfigurableIORate) {
            ((IConfigurableIORate)((Object)this.internalTank)).setOutputRate(rate);
        } else {
            this.internalTankOutputRate = rate;
        }
    }

    @Override
    public int getItemStorageInputRate(ItemStack itemStack) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            if (fluidHandler instanceof IConfigurableIORateForgeFluid) {
                return ((IConfigurableIORate)fluidHandler).getInputRate();
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Override
    public int getItemStorageOutputRate(ItemStack itemStack) {
        IFluidHandler fluidHandler = ForgeFluidUtil.getFluidHandlerFromItemStack(itemStack);
        if (fluidHandler != null) {
            if (fluidHandler instanceof IConfigurableIORateForgeFluid) {
                return ((IConfigurableIORate)fluidHandler).getOutputRate();
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

